/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class FeatureMap
extends ArrayList<LinkedList<Holder<PlacedFeature>>> {
    public static final Codec<List<List<Holder<PlacedFeature>>>> CODEC = PlacedFeature.CODEC.listOf().listOf();

    public void addFeature(GenerationStep.Decoration decoration, Holder<PlacedFeature> feature) {
        this.getFeatures(decoration).add(feature);
    }

    public List<Holder<PlacedFeature>> getFeatures(GenerationStep.Decoration decoration) {
        int index = decoration.ordinal();
        while (this.size() <= index) {
            this.add(new LinkedList());
        }
        return (List)this.get(index);
    }

    public static HolderSet<PlacedFeature> getFeatures(List<HolderSet<PlacedFeature>> features, GenerationStep.Decoration decoration) {
        int index = decoration.ordinal();
        while (features.size() <= index) {
            features.add((HolderSet<PlacedFeature>)HolderSet.direct(Collections.emptyList()));
        }
        return features.get(index);
    }

    public void forEach(BiConsumer<GenerationStep.Decoration, Holder<PlacedFeature>> consumer) {
        for (int i = 0; i < this.size(); ++i) {
            GenerationStep.Decoration decoration = GenerationStep.Decoration.values()[i];
            for (Holder<PlacedFeature> feature : this.getFeatures(decoration)) {
                consumer.accept(decoration, feature);
            }
        }
    }

    public List<List<Holder<PlacedFeature>>> generic() {
        FeatureMap res = this;
        return res;
    }

    public static FeatureMap of(List<List<Holder<PlacedFeature>>> features) {
        FeatureMap map = new FeatureMap();
        for (List<Holder<PlacedFeature>> list : features) {
            if (list instanceof LinkedList) {
                LinkedList lList = (LinkedList)list;
                map.add(lList);
                continue;
            }
            LinkedList<Holder<PlacedFeature>> nList = new LinkedList<Holder<PlacedFeature>>(list);
            map.add(nList);
        }
        return map;
    }
}

