/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.betterx.wover.biome.mixin.ChunkGeneratorAccessor;
import org.betterx.wover.entrypoint.LibWoverBiome;

public class ChunkGeneratorHelper {
    public static void rebuildFeaturesPerStep(ChunkGenerator generator, BiomeSource biomeSource) {
        if (generator instanceof ChunkGeneratorAccessor) {
            ChunkGeneratorAccessor acc = (ChunkGeneratorAccessor)generator;
            Function<Holder, BiomeGenerationSettings> function = biomeHolder -> ((Biome)biomeHolder.value()).getGenerationSettings();
            acc.wover_setFeaturesPerStep((Supplier<List<FeatureSorter.StepFeatureData>>)Suppliers.memoize(() -> {
                try {
                    return FeatureSorter.buildFeaturesPerStep(List.copyOf(biomeSource.possibleBiomes()), hh -> ((BiomeGenerationSettings)function.apply((Holder)hh)).features(), (boolean)true);
                }
                catch (IllegalStateException e) {
                    String message = e.getMessage();
                    LibWoverBiome.C.LOG.error("Failed to rebuild features per step", (Exception)e);
                    for (Holder biome : biomeSource.possibleBiomes()) {
                        String loc = ((ResourceKey)biome.unwrapKey().orElseThrow()).location().toString();
                        if (!message.contains(loc)) continue;
                        BiomeGenerationSettings res = ((Biome)biome.value()).getGenerationSettings();
                        LibWoverBiome.C.LOG.verbose(loc);
                        int ct = 0;
                        for (HolderSet feature : res.features()) {
                            LibWoverBiome.C.LOG.verbose("  -------" + ct + "-------");
                            ++ct;
                            for (int i = 0; i < feature.size(); ++i) {
                                LibWoverBiome.C.LOG.verbose("    + " + ((ResourceKey)feature.get(i).unwrapKey().orElseThrow()).location().toString());
                            }
                        }
                    }
                    throw e;
                }
            }));
        }
    }
}

