/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.builder;

import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.builder.BiomeBuilder;
import org.betterx.wover.biome.api.builder.BiomeSurfaceRuleBuilder;
import org.betterx.wover.surface.api.AssignedSurfaceRule;
import org.betterx.wover.surface.api.SurfaceRuleRegistry;
import org.betterx.wover.surface.impl.SurfaceRuleBuilderImpl;
import org.betterx.wover.surface.impl.SurfaceRuleRegistryImpl;
import org.jetbrains.annotations.NotNull;

public class BiomeSurfaceRuleBuilderImpl<B extends BiomeBuilder<B>>
extends SurfaceRuleBuilderImpl<BiomeSurfaceRuleBuilder<B>>
implements BiomeSurfaceRuleBuilder<B> {
    private final B sourceBuilder;

    public BiomeSurfaceRuleBuilderImpl(BiomeKey<?> biomeKey, B sourceBuilder) {
        this.biome(biomeKey.key);
        this.sourceBuilder = sourceBuilder;
    }

    public void register(@NotNull BootstrapContext<AssignedSurfaceRule> ctx) {
        ResourceKey ruleKey = SurfaceRuleRegistry.createKey((ResourceLocation)this.biomeKey.location());
        SurfaceRuleRegistryImpl.register(ctx, (ResourceKey)ruleKey, (ResourceKey)this.biomeKey, (SurfaceRules.RuleSource)this.getRuleSource(), (int)this.sortPriority);
    }

    @Override
    public B finishSurface() {
        return this.sourceBuilder;
    }
}

