/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.api.modification.predicates;

import com.mojang.serialization.Codec;
import de.ambertation.wunderlib.configs.AbstractConfig;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.betterx.wover.biome.impl.modification.predicates.Always;
import org.betterx.wover.biome.impl.modification.predicates.And;
import org.betterx.wover.biome.impl.modification.predicates.BiomePredicateRegistryImpl;
import org.betterx.wover.biome.impl.modification.predicates.ConfigIs;
import org.betterx.wover.biome.impl.modification.predicates.HasConfiguredFeature;
import org.betterx.wover.biome.impl.modification.predicates.HasPlacedFeature;
import org.betterx.wover.biome.impl.modification.predicates.HasStructure;
import org.betterx.wover.biome.impl.modification.predicates.HasTag;
import org.betterx.wover.biome.impl.modification.predicates.InDimension;
import org.betterx.wover.biome.impl.modification.predicates.IsBiome;
import org.betterx.wover.biome.impl.modification.predicates.IsNamespace;
import org.betterx.wover.biome.impl.modification.predicates.LocationPathContains;
import org.betterx.wover.biome.impl.modification.predicates.Not;
import org.betterx.wover.biome.impl.modification.predicates.Or;
import org.betterx.wover.biome.impl.modification.predicates.Spawns;
import org.betterx.wover.core.api.ModCore;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BiomePredicate {
    public static final Codec<BiomePredicate> CODEC = BiomePredicateRegistryImpl.BIOME_PREDICATES.byNameCodec().dispatch(p -> p.codec().codec(), Function.identity());

    public static BiomePredicate or(BiomePredicate ... predicates) {
        return new Or(List.of(predicates));
    }

    public static BiomePredicate and(BiomePredicate ... predicates) {
        return new And(List.of(predicates));
    }

    public static BiomePredicate anyOf(BiomePredicate ... predicates) {
        return BiomePredicate.or(predicates);
    }

    public static BiomePredicate allOf(BiomePredicate ... predicates) {
        return BiomePredicate.and(predicates);
    }

    public static BiomePredicate not(BiomePredicate predicate) {
        return new Not(predicate);
    }

    public static BiomePredicate always() {
        return Always.INSTANCE;
    }

    public static BiomePredicate isBiome(ResourceKey<Biome> key) {
        return new IsBiome(key);
    }

    @SafeVarargs
    public static BiomePredicate inBiomes(ResourceKey<Biome> ... keys) {
        return new Or(Arrays.stream(keys).map(biomeKey -> new IsBiome((ResourceKey<Biome>)biomeKey)).toList());
    }

    @SafeVarargs
    public static BiomePredicate notInBiomes(ResourceKey<Biome> ... keys) {
        return new Not(BiomePredicate.inBiomes(keys));
    }

    public static BiomePredicate inDimension(ResourceKey<LevelStem> key) {
        return new InDimension(key);
    }

    public static BiomePredicate inOverworld() {
        return InDimension.OVERWORLD;
    }

    public static BiomePredicate inEnd() {
        return InDimension.END;
    }

    public static BiomePredicate inNether() {
        return InDimension.NETHER;
    }

    public static BiomePredicate hasTag(TagKey<Biome> tag) {
        return new HasTag(tag);
    }

    public static BiomePredicate spawns(EntityType<?> type) {
        return new Spawns(type);
    }

    public static BiomePredicate hasStructure(ResourceKey<Structure> key) {
        return new HasStructure(key);
    }

    public static BiomePredicate hasPlacedFeature(ResourceKey<PlacedFeature> key) {
        return new HasPlacedFeature(key);
    }

    public static BiomePredicate hasConfiguredFeature(ResourceKey<ConfiguredFeature<?, ?>> key) {
        return new HasConfiguredFeature(key);
    }

    public static BiomePredicate isVanilla() {
        return new IsNamespace("minecraft");
    }

    public static BiomePredicate inNamespace(String namespace) {
        return new IsNamespace(namespace);
    }

    public static BiomePredicate inNamespace(ModCore core) {
        return new IsNamespace(core.namespace);
    }

    public static BiomePredicate notInNamespace(String namespace) {
        return BiomePredicate.not(new IsNamespace(namespace));
    }

    public static BiomePredicate notInNamespace(ModCore core) {
        return BiomePredicate.not(new IsNamespace(core.namespace));
    }

    public static BiomePredicate pathContains(String needle) {
        return new LocationPathContains(needle);
    }

    public static <T, R extends AbstractConfig.Value<T, R>> BiomePredicate hasConfig(AbstractConfig.Value<T, R> value, T targetValue) {
        return ConfigIs.of(value, targetValue);
    }

    @ApiStatus.Internal
    public KeyDispatchDataCodec<? extends BiomePredicate> codec();

    public boolean test(Context var1);

    public static final class Context {
        @NotNull
        public final RegistryAccess registryAccess;
        @NotNull
        public final ResourceKey<Biome> biomeKey;
        @NotNull
        public final Biome biome;
        @NotNull
        public final Holder<Biome> biomeHolder;
        @NotNull
        public final Registry<Biome> biomes;
        @NotNull
        public final Registry<LevelStem> levelStems;
        @NotNull
        public final Registry<Structure> structures;
        @NotNull
        public final Registry<PlacedFeature> placedFeatures;
        @NotNull
        public final Registry<ConfiguredFeature<?, ?>> configuredFeatures;

        private Context(@NotNull RegistryAccess registryAccess, @NotNull Registry<Biome> biomes, @NotNull ResourceKey<Biome> biomeKey, @NotNull Biome biome) {
            this.registryAccess = registryAccess;
            this.biomeKey = biomeKey;
            this.biomes = biomes;
            this.levelStems = registryAccess.registryOrThrow(Registries.LEVEL_STEM);
            this.structures = registryAccess.registryOrThrow(Registries.STRUCTURE);
            this.placedFeatures = registryAccess.registryOrThrow(Registries.PLACED_FEATURE);
            this.configuredFeatures = registryAccess.registryOrThrow(Registries.CONFIGURED_FEATURE);
            this.biome = biome;
            this.biomeHolder = biomes.getHolderOrThrow(biomeKey);
        }

        @ApiStatus.Internal
        @Nullable
        public static Context of(@Nullable RegistryAccess registryAccess, @NotNull ResourceKey<Biome> biomeKey) {
            if (registryAccess == null) {
                return null;
            }
            Registry biomes = registryAccess.registryOrThrow(Registries.BIOME);
            return Context.of(registryAccess, (Registry<Biome>)biomes, biomeKey);
        }

        @ApiStatus.Internal
        @Nullable
        public static Context of(@Nullable RegistryAccess registryAccess, @Nullable Registry<Biome> biomes, @NotNull ResourceKey<Biome> biomeKey) {
            if (biomes == null || registryAccess == null) {
                return null;
            }
            Biome biome = (Biome)biomes.get(biomeKey);
            if (biome == null) {
                return null;
            }
            return new Context(registryAccess, biomes, biomeKey, biome);
        }
    }
}

