/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.api;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.betterx.wover.biome.api.builder.BiomeBootstrapContext;
import org.betterx.wover.biome.api.builder.BiomeBuilder;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.biome.impl.BiomeManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BiomeKey<B extends BiomeBuilder<B>> {
    @NotNull
    public final ResourceKey<Biome> key;
    @NotNull
    public final ResourceKey<BiomeData> dataKey;

    @Nullable
    public Holder<Biome> getHolder(@Nullable HolderGetter<Biome> getter) {
        return getter == null ? null : (Holder)getter.get(this.key).orElse(null);
    }

    @Nullable
    public Holder<Biome> getHolder(@Nullable RegistryAccess access) {
        return access == null ? null : (Holder)access.registryOrThrow(Registries.BIOME).getHolder(this.key).orElse(null);
    }

    @Nullable
    public Holder<Biome> getHolder(@Nullable // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return provider == null ? null : (Holder)((HolderLookup.RegistryLookup)provider.lookup(Registries.BIOME).orElseThrow()).get(this.key).orElse(null);
    }

    public Holder<Biome> getHolder(@NotNull BootstrapContext<?> context) {
        return context.lookup(Registries.BIOME).get(this.key).orElse(null);
    }

    public abstract B bootstrap(BiomeBootstrapContext var1);

    protected BiomeKey(@NotNull ResourceLocation location) {
        this.key = BiomeManagerImpl.createKey(location);
        this.dataKey = BiomeDataRegistry.createKey(location);
    }
}

