/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.tags.manager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.dhyces.trimmed.Trimmed;
import dev.dhyces.trimmed.TrimmedClient;
import dev.dhyces.trimmed.api.KeyResolver;
import dev.dhyces.trimmed.api.client.tag.ClientTagKey;
import dev.dhyces.trimmed.api.client.tag.TagHolder;
import dev.dhyces.trimmed.api.data.client.tag.ClientTagEntry;
import dev.dhyces.trimmed.api.data.client.tag.ClientTagFile;
import dev.dhyces.trimmed.api.util.Utils;
import dev.dhyces.trimmed.impl.client.GameRegistryHolder;
import dev.dhyces.trimmed.impl.client.maps.KeyResolvers;
import dev.dhyces.trimmed.modhelper.services.Services;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.DependencySorter;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTagManager
implements PreparableReloadListener {
    public static final String PATH = "trimmed/tags/";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Trimmed / Client Tags");
    private static final Map<ClientTagKey<?>, ClientTagHolder<?>> REGISTRY = new Reference2ObjectOpenHashMap();

    public static <T> TagHolder<T> getHolder(ClientTagKey<T> clientTagKey) {
        return ClientTagManager.getOrCreateHolder(clientTagKey);
    }

    private static <T> ClientTagHolder<T> getOrCreateHolder(ClientTagKey<T> clientTagKey) {
        return REGISTRY.computeIfAbsent(clientTagKey, ClientTagHolder::new);
    }

    @Nullable
    private static <T> ClientTagHolder<T> getExistingHolder(ClientTagKey<T> clientTagKey) {
        return REGISTRY.get(clientTagKey);
    }

    public static void updateDatapacksSynced(GameRegistryHolder registryHolder) {
        ClientTagManager.load(Minecraft.getInstance().getResourceManager(), registryHolder, true);
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier pPreparationBarrier, ResourceManager pResourceManager, ProfilerFiller pPreparationsProfiler, ProfilerFiller pReloadProfiler, Executor pBackgroundExecutor, Executor pGameExecutor) {
        REGISTRY.values().forEach(ClientTagHolder::reset);
        return ((CompletableFuture)ClientTagManager.load(pResourceManager, TrimmedClient.getStaticHolder(), false).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)pPreparationBarrier).wait(arg_0))).thenRun(() -> Trimmed.logInDev("Client tags loaded!"));
    }

    private static CompletableFuture<Unit> load(ResourceManager resourceManager, GameRegistryHolder registryHolder, boolean onlyLoadSynced) {
        for (Map.Entry<ResourceLocation, KeyResolver<?>> entry : KeyResolvers.getEntries()) {
            if (!(onlyLoadSynced ? entry.getValue().requiresActiveWorld() && registryHolder.isSynced() : !entry.getValue().requiresActiveWorld() || registryHolder.isSynced())) continue;
            ClientTagManager.resolveTags(entry.getKey(), entry.getValue(), resourceManager, (DynamicOps<JsonElement>)registryHolder.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE));
        }
        return CompletableFuture.completedFuture(Unit.INSTANCE);
    }

    private static <T> void resolveTags(ResourceLocation registryId, KeyResolver<T> keyResolver, ResourceManager resourceManager, DynamicOps<JsonElement> jsonOps) {
        String resolverPath = PATH + Utils.namespacedPath(registryId);
        FileToIdConverter converter = FileToIdConverter.json((String)resolverPath);
        Map unresolved = (Map)Utils.unsafeCast(ClientTagManager.readMap(converter, resourceManager, keyResolver, jsonOps));
        DependencySorter sorter = new DependencySorter();
        unresolved.forEach((resourceLocation, entries) -> sorter.addEntry(resourceLocation, new TagSetEntry((Set<ClientTagEntry>)entries)));
        sorter.orderByDependencies((resourceLocation, tagEntrySet) -> {
            try {
                ClientTagManager.resolveEntry(resourceLocation, tagEntrySet, keyResolver, jsonOps);
            }
            catch (IllegalStateException e) {
                LOGGER.error("Could not resolve entry", (Throwable)e);
            }
        });
    }

    private static <T> Map<ResourceLocation, Set<ClientTagEntry>> readMap(FileToIdConverter converter, ResourceManager resourceManager, KeyResolver<T> keyResolver, DynamicOps<JsonElement> jsonOps) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : converter.listMatchingResourceStacks(resourceManager).entrySet()) {
            ResourceLocation id = converter.fileToId((ResourceLocation)entry.getKey());
            try {
                builder.put((Object)id, ClientTagManager.readResources(id, (List)entry.getValue(), keyResolver, jsonOps));
            }
            catch (IllegalStateException e) {
                LOGGER.error("Failed to parse client tag", (Throwable)e);
            }
        }
        return builder.build();
    }

    private static <T> Set<ClientTagEntry> readResources(ResourceLocation fileName, List<Resource> resourceStack, KeyResolver<T> keyResolver, DynamicOps<JsonElement> jsonOps) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (Resource resource : resourceStack) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonObject json = GsonHelper.parse((Reader)reader);
                    Optional<ClientTagFile> result = Services.PLATFORM_HELPER.decodeWithConditions(ClientTagFile.CODEC, jsonOps, json);
                    if (result.isEmpty()) {
                        LOGGER.debug("Skipping loading client tag {} as its conditions were not met", (Object)fileName);
                        continue;
                    }
                    ClientTagFile tagFile = result.get();
                    if (tagFile.replace()) {
                        setBuilder = ImmutableSet.builder();
                    }
                    setBuilder.addAll(tagFile.entries());
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (JsonParseException | IOException e) {
                throw new IllegalStateException("Failed to read %s from %s: ".formatted(fileName, resource.source().packId()), e);
            }
        }
        return setBuilder.build();
    }

    private static <T> void resolveEntry(ResourceLocation id, TagSetEntry<T> tagSetEntry, KeyResolver<T> resolver, DynamicOps<JsonElement> jsonOps) {
        ReferenceLinkedOpenHashSet optionalSet;
        ReferenceLinkedOpenHashSet set;
        ClientTagKey<T> key = ClientTagKey.of(resolver, id);
        if (resolver instanceof KeyResolver.RegistryResolver) {
            set = new ReferenceLinkedOpenHashSet();
            optionalSet = new ReferenceLinkedOpenHashSet();
        } else {
            set = new ObjectLinkedOpenHashSet();
            optionalSet = new ObjectLinkedOpenHashSet();
        }
        for (ClientTagEntry tagEntry : tagSetEntry.entries()) {
            if (tagEntry.isTag()) {
                ClientTagKey<T> clientTagKey = tagEntry.getTag(resolver);
                ClientTagHolder<T> holder = ClientTagManager.getExistingHolder(clientTagKey);
                if (holder != null && holder.backingSet != null) {
                    holder.mergeInto((Set<T>)set, (Set<T>)optionalSet);
                    continue;
                }
                if (!tagEntry.isRequired()) continue;
                throw new IllegalStateException("Could not get required client tag \"%s\" for \"%s\"".formatted(clientTagKey.getTagId(), id));
            }
            T element = resolver.decode(tagEntry.getId(), jsonOps);
            if (element == null) {
                if (!tagEntry.isRequired()) continue;
                throw new IllegalStateException("Could not parse required element for \"%s\"".formatted(id));
            }
            set.add(element);
            if (tagEntry.isRequired()) continue;
            optionalSet.add(element);
        }
        ClientTagManager.getOrCreateHolder(key).update((Set<T>)set, (Set<T>)optionalSet);
    }

    static class ClientTagHolder<T>
    implements TagHolder<T> {
        private final ClientTagKey<T> key;
        private Set<T> backingSet;
        private Set<T> optionalElements;

        public ClientTagHolder(ClientTagKey<T> key) {
            this.key = key;
        }

        private void update(Set<T> backingSet, Set<T> optionalElements) {
            this.backingSet = backingSet;
            this.optionalElements = optionalElements;
        }

        private void reset() {
            this.backingSet = null;
            this.optionalElements = null;
        }

        private void mergeInto(Set<T> set, Set<T> optionalElements) {
            set.addAll(this.backingSet);
            if (this.optionalElements != null) {
                optionalElements.addAll(this.optionalElements);
            }
        }

        @Override
        public ClientTagKey<T> unwrapKey() {
            return this.key;
        }

        @Override
        public Set<T> getSet() {
            if (this.backingSet == null) {
                Trimmed.LOGGER.error("Cannot access tag set for {} because it doesn't exist!", this.key);
                return Set.of();
            }
            return this.backingSet;
        }

        @Override
        public boolean isRequired(T element) {
            if (this.optionalElements == null) {
                return true;
            }
            return this.optionalElements.contains(element);
        }

        @Override
        public boolean isBound() {
            return this.backingSet != null;
        }
    }

    record TagSetEntry<T>(Set<ClientTagEntry> entries) implements DependencySorter.Entry<ResourceLocation>
    {
        public void visitRequiredDependencies(Consumer<ResourceLocation> visitor) {
            this.entries.forEach(tagEntry -> {
                if (tagEntry.isTag() && tagEntry.isRequired()) {
                    visitor.accept(tagEntry.getId());
                }
            });
        }

        public void visitOptionalDependencies(Consumer<ResourceLocation> visitor) {
            this.entries.forEach(tagEntry -> {
                if (tagEntry.isTag() && !tagEntry.isRequired()) {
                    visitor.accept(tagEntry.getId());
                }
            });
        }
    }
}

