/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.models.source;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.dhyces.trimmed.api.client.TrimmedClientMapApi;
import dev.dhyces.trimmed.api.client.map.ClientMapKeys;
import dev.dhyces.trimmed.api.client.map.ClientMapTypes;
import dev.dhyces.trimmed.api.maps.MapHolder;
import dev.dhyces.trimmed.impl.client.models.source.ModelSource;
import dev.dhyces.trimmed.impl.client.models.source.NamedModel;
import dev.dhyces.trimmed.impl.client.models.template.ModelTemplateManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public record TrimModelSource(ResourceLocation template, MapHolder<ResourceLocation, ResourceLocation> textures, MapHolder<ResourceLocation, ResourceLocation> overrides) implements ModelSource
{
    public static final MapCodec<TrimModelSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("template").forGetter(TrimModelSource::template), (App)TrimmedClientMapApi.getInstance().simpleCodec(ClientMapTypes.TEXTURE_MAPPING).fieldOf("textures").forGetter(TrimModelSource::textures), (App)TrimmedClientMapApi.getInstance().simpleCodec(ClientMapTypes.TEXTURE_MAPPING).fieldOf("override_textures").forGetter(TrimModelSource::overrides)).apply((Applicative)instance, TrimModelSource::new));
    private static final MapHolder<ResourceLocation, String> MATERIALS = TrimmedClientMapApi.getInstance().getSimpleMap(ClientMapKeys.MATERIAL_SUFFIXES);
    private static final MapHolder<ResourceLocation, String> DARKER_MATERIALS = TrimmedClientMapApi.getInstance().getSimpleMap(ClientMapKeys.DARKER_MATERIAL_SUFFIXES);
    public static final String ITEM_TEXTURE = "item_texture";
    public static final String TRIM_TEXTURE = "trim_overlay_texture";
    public static final String MATERIAL_SUFFIX = "material_suffix";

    @Override
    public Collection<NamedModel> generate(ResourceManager resourceManager, ModelTemplateManager templateManager) {
        ImmutableList.Builder modelBuilder = ImmutableList.builder();
        Object2ObjectArrayMap replacer = new Object2ObjectArrayMap();
        for (Map.Entry<ResourceLocation, ResourceLocation> textureEntry : this.textures.getMap().entrySet()) {
            replacer.put((Object)ITEM_TEXTURE, (Object)textureEntry.getKey().toString());
            replacer.put((Object)TRIM_TEXTURE, (Object)textureEntry.getValue().toString());
            for (Map.Entry<ResourceLocation, String> materialEntry : MATERIALS.getMap().entrySet()) {
                if (DARKER_MATERIALS.getMap().containsKey(materialEntry.getKey())) continue;
                String suffix = materialEntry.getValue();
                if (this.overrides.isBound() && this.overrides.getMap().containsKey(materialEntry.getKey())) {
                    suffix = MATERIALS.getMap().get(this.overrides.getMap().get(materialEntry.getKey()));
                }
                replacer.put((Object)MATERIAL_SUFFIX, (Object)suffix);
                String processed = templateManager.process(this.template, (Function<String, String>)replacer);
                ResourceLocation id = textureEntry.getKey().withSuffix("_" + suffix + "_trim");
                modelBuilder.add((Object)NamedModel.item(id, () -> BlockModel.fromString((String)processed)));
            }
        }
        return modelBuilder.build();
    }

    @Override
    public MapCodec<? extends ModelSource> codec() {
        return CODEC;
    }
}

