/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.models.source;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.dhyces.trimmed.Trimmed;
import dev.dhyces.trimmed.api.util.CodecUtil;
import dev.dhyces.trimmed.impl.client.models.source.ModelSource;
import dev.dhyces.trimmed.impl.client.models.source.TrimModelSource;
import net.minecraft.resources.ResourceLocation;

public class ModelSourceRegistry {
    private static final BiMap<ResourceLocation, MapCodec<? extends ModelSource>> REGISTRY = HashBiMap.create();
    public static final Codec<ModelSource> CODEC = CodecUtil.TRIMMED_IDENTIFIER.dispatch(modelSource -> (ResourceLocation)REGISTRY.inverse().get(modelSource.codec()), arg_0 -> REGISTRY.get(arg_0));

    public static void register(ResourceLocation id, MapCodec<? extends ModelSource> mapCodec) {
        if (REGISTRY.putIfAbsent((Object)id, mapCodec) != null) {
            throw new IllegalArgumentException("Codec already registered for " + String.valueOf(id));
        }
    }

    public static void init() {
        ModelSourceRegistry.register(Trimmed.id("trims"), TrimModelSource.CODEC);
    }
}

