/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.models.source;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.dhyces.trimmed.Trimmed;
import dev.dhyces.trimmed.impl.client.maps.manager.ClientMapManager;
import dev.dhyces.trimmed.impl.client.models.source.ModelSource;
import dev.dhyces.trimmed.impl.client.models.source.ModelSourceRegistry;
import dev.dhyces.trimmed.impl.client.models.source.NamedModel;
import dev.dhyces.trimmed.impl.client.models.template.ModelTemplateManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;

public final class ModelSourceLoader {
    private static final FileToIdConverter MODEL_SOURCE_CONVERTER = new FileToIdConverter("trimmed/model_generators", ".json");

    private ModelSourceLoader() {
    }

    public static CompletableFuture<Collection<NamedModel>> load(ModelTemplateManager templateManager, ResourceManager resourceManager, Executor executor) {
        return ClientMapManager.future().thenApplyAsync(unit -> {
            ObjectArrayList models = new ObjectArrayList();
            for (Map.Entry entry : MODEL_SOURCE_CONVERTER.listMatchingResources(resourceManager).entrySet()) {
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                    try {
                        JsonObject json = GsonHelper.parse((Reader)reader, (boolean)true);
                        ModelSource modelSource = (ModelSource)ModelSourceRegistry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
                        models.addAll(modelSource.generate(resourceManager, templateManager));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (JsonParseException | IOException | IllegalStateException e) {
                    Trimmed.LOGGER.error("Failed to read %s from %s: ".formatted(entry.getKey(), ((Resource)entry.getValue()).source().packId()), e);
                }
            }
            return models;
        }, executor);
    }
}

