/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.models.override;

import dev.dhyces.trimmed.api.client.override.provider.ItemOverrideProvider;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemOverrideRegistry {
    private static final Map<Item, Set<ItemOverrideProvider>> OVERRIDE_SET_MAP = new Reference2ObjectOpenHashMap();

    public static Optional<BakedModel> getOverrideModel(ItemStack itemStack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
        Set<ItemOverrideProvider> providers = OVERRIDE_SET_MAP.get(itemStack.getItem());
        if (providers == null) {
            return Optional.empty();
        }
        for (ItemOverrideProvider provider : providers) {
            Optional<BakedModel> model = provider.getModel(itemStack, world, entity, seed);
            if (!model.isPresent()) continue;
            return model;
        }
        return Optional.empty();
    }

    public static Optional<Set<ItemOverrideProvider>> getOverrides(ResourceLocation modelId) {
        return Optional.ofNullable(OVERRIDE_SET_MAP.get(BuiltInRegistries.ITEM.get(modelId)));
    }

    static void addOverrideSet(ResourceLocation identifier, Set<ItemOverrideProvider> set) {
        OVERRIDE_SET_MAP.put((Item)BuiltInRegistries.ITEM.get(identifier), set);
    }

    static void clearRegistry() {
        OVERRIDE_SET_MAP.clear();
    }
}

