/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.maps.manager;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.dhyces.trimmed.Trimmed;
import dev.dhyces.trimmed.TrimmedClient;
import dev.dhyces.trimmed.api.maps.MapHolder;
import dev.dhyces.trimmed.api.maps.MapKey;
import dev.dhyces.trimmed.api.util.Utils;
import dev.dhyces.trimmed.impl.client.GameRegistryHolder;
import dev.dhyces.trimmed.impl.client.maps.KeyResolvers;
import dev.dhyces.trimmed.impl.client.maps.manager.MapHandler;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;

public class ClientMapManager
implements PreparableReloadListener {
    public static final String PATH = "trimmed/maps";
    private static CompletableFuture<Unit> completable = new CompletableFuture();
    private static final Map<MapKey<?, ?>, MapHandler<?, ?>> REGISTRY = new Reference2ObjectOpenHashMap();

    public static <K, V> void registerBaseKey(MapKey<K, V> key) {
        if (key.isSubKey()) {
            throw new IllegalArgumentException("Illegal id {%s}. Id cannot contain sub-paths \"/\".".formatted(key));
        }
        if (KeyResolvers.getId(key.getType().getKeyResolver()) == null) {
            throw new IllegalArgumentException("KeyResolver for %s is not registered".formatted(key));
        }
        if (!REGISTRY.containsKey(key)) {
            REGISTRY.put(key, new MapHandler<K, V>(key));
        }
    }

    public static <K, V> MapHolder<K, V> getHolder(MapKey<K, V> key) {
        return REGISTRY.computeIfAbsent(key.isSubKey() ? key.getBaseKey() : key, MapHandler::new).getHolder((MapKey)Utils.unsafeCast(key));
    }

    public static CompletableFuture<Unit> future() {
        return completable;
    }

    public static void updateDatapacksSynced(GameRegistryHolder registryHolder) {
        ClientMapManager.load(Minecraft.getInstance().getResourceManager(), registryHolder, true);
    }

    private static void finishReload() {
        Trimmed.logInDev("Client maps loaded!");
        completable = new CompletableFuture();
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier pPreparationBarrier, ResourceManager pResourceManager, ProfilerFiller pPreparationsProfiler, ProfilerFiller pReloadProfiler, Executor pBackgroundExecutor, Executor pGameExecutor) {
        REGISTRY.values().forEach(MapHandler::clear);
        return ((CompletableFuture)((CompletableFuture)ClientMapManager.load(pResourceManager, TrimmedClient.getStaticHolder(), false).thenApply(completable::complete)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)pPreparationBarrier).wait(arg_0))).thenRun(ClientMapManager::finishReload);
    }

    private static CompletableFuture<Unit> load(ResourceManager resourceManager, GameRegistryHolder registryHolder, boolean onlyLoadSynced) {
        for (Map.Entry<MapKey<?, ?>, MapHandler<?, ?>> entry : REGISTRY.entrySet()) {
            ResourceLocation resolverPath = entry.getKey().getMapId().withPrefix("trimmed/maps/" + Utils.namespacedPath(KeyResolvers.getId(entry.getKey().getType().getKeyResolver())) + "/");
            FileToIdConverter converter = FileToIdConverter.json((String)resolverPath.getPath());
            try {
                if (!(onlyLoadSynced ? entry.getKey().getType().isDataPackSynced() && registryHolder.isSynced() : !entry.getKey().getType().isDataPackSynced() || registryHolder.isSynced())) continue;
                entry.getValue().parse(resolverPath, converter, resourceManager, (DynamicOps<JsonElement>)registryHolder.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE));
            }
            catch (RuntimeException e) {
                Trimmed.LOGGER.error("Could not read map", (Throwable)e);
            }
        }
        return CompletableFuture.completedFuture(Unit.INSTANCE);
    }
}

