/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.atlas;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.dhyces.trimmed.Trimmed;
import dev.dhyces.trimmed.api.client.ClientKeyResolvers;
import dev.dhyces.trimmed.api.client.TrimmedClientMapApi;
import dev.dhyces.trimmed.api.client.TrimmedClientTagApi;
import dev.dhyces.trimmed.api.client.map.ClientMapTypes;
import dev.dhyces.trimmed.api.client.tag.TagHolder;
import dev.dhyces.trimmed.api.maps.MapHolder;
import dev.dhyces.trimmed.impl.client.atlas.TrimmedSpriteSourceTypes;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;

public class OpenPalettedPermutations
implements SpriteSource {
    public static final MapCodec<OpenPalettedPermutations> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("palette_key").forGetter(openPalettedPermutations -> openPalettedPermutations.paletteKey), (App)TrimmedClientMapApi.getInstance().simpleCodec(ClientMapTypes.TEXTURE_SUFFIX).fieldOf("permutation_map").forGetter(openPalettedPermutations -> openPalettedPermutations.permutations), (App)TrimmedClientTagApi.getInstance().tagCodec(ClientKeyResolvers.TEXTURE).fieldOf("texture_set").forGetter(openPalettedPermutations -> openPalettedPermutations.textures)).apply((Applicative)instance, OpenPalettedPermutations::new));
    private final ResourceLocation paletteKey;
    private final MapHolder<ResourceLocation, String> permutations;
    private final TagHolder<ResourceLocation> textures;

    public OpenPalettedPermutations(ResourceLocation paletteKey, MapHolder<ResourceLocation, String> permutations, TagHolder<ResourceLocation> textures) {
        this.paletteKey = paletteKey;
        this.permutations = permutations;
        this.textures = textures;
    }

    public void run(ResourceManager pResourceManager, SpriteSource.Output pOutput) {
        Supplier rawPaletteKeyImage = Suppliers.memoize(() -> PalettedPermutations.loadPaletteEntryFromImage((ResourceManager)pResourceManager, (ResourceLocation)this.paletteKey));
        Object2ObjectOpenHashMap replacePixelsMap = new Object2ObjectOpenHashMap();
        this.permutations.getMap().forEach((arg_0, arg_1) -> this.lambda$run$6((Map)replacePixelsMap, (java.util.function.Supplier)rawPaletteKeyImage, pResourceManager, arg_0, arg_1));
        this.textures.getSet().forEach(arg_0 -> this.lambda$run$7(pResourceManager, (Map)replacePixelsMap, pOutput, arg_0));
    }

    public SpriteSourceType type() {
        return TrimmedSpriteSourceTypes.OPEN_PALETTED_PERMUTATIONS.get();
    }

    private /* synthetic */ void lambda$run$7(ResourceManager pResourceManager, Map replacePixelsMap, SpriteSource.Output pOutput, ResourceLocation texture) {
        Optional imageOptional = pResourceManager.getResource(TEXTURE_ID_CONVERTER.idToFile(texture));
        if (imageOptional.isEmpty() && this.textures.isRequired(texture)) {
            Trimmed.LOGGER.error("Cannot locate required {}", (Object)texture);
        } else if (imageOptional.isPresent()) {
            LazyLoadedImage lazyloadedimage = new LazyLoadedImage(texture, (Resource)imageOptional.get(), replacePixelsMap.size());
            for (Map.Entry entry : replacePixelsMap.entrySet()) {
                ResourceLocation permutedId = texture.withSuffix("_" + ((ResourceLocation)entry.getKey()).getPath());
                pOutput.add(permutedId, (SpriteSource.SpriteSupplier)new OpenPalettedSpriteSupplier(lazyloadedimage, (OptionalSupplier)entry.getValue(), permutedId));
            }
        }
    }

    private /* synthetic */ void lambda$run$6(Map replacePixelsMap, java.util.function.Supplier rawPaletteKeyImage, ResourceManager pResourceManager, ResourceLocation id, String permuteString) {
        replacePixelsMap.put(id.withPath(permuteString), new OptionalSupplier(this.permutations.isRequired(id), (java.util.function.Supplier<IntUnaryOperator>)Suppliers.memoize(() -> OpenPalettedPermutations.lambda$run$5((java.util.function.Supplier)rawPaletteKeyImage, pResourceManager, id))));
    }

    private static /* synthetic */ IntUnaryOperator lambda$run$5(java.util.function.Supplier rawPaletteKeyImage, ResourceManager pResourceManager, ResourceLocation id) {
        return PalettedPermutations.createPaletteMapping((int[])((int[])rawPaletteKeyImage.get()), (int[])PalettedPermutations.loadPaletteEntryFromImage((ResourceManager)pResourceManager, (ResourceLocation)id));
    }

    public record OpenPalettedSpriteSupplier(LazyLoadedImage lazyLoadedImage, OptionalSupplier optionalSupplier, ResourceLocation permutedId) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteContents apply(SpriteResourceLoader spriteResourceLoader) {
            try {
                NativeImage image = this.lazyLoadedImage.get().mappedCopy(this.optionalSupplier.mapper.get());
                SpriteContents spriteContents = new SpriteContents(this.permutedId, new FrameSize(image.getWidth(), image.getHeight()), image, ResourceMetadata.EMPTY);
                return spriteContents;
            }
            catch (IOException e) {
                if (this.optionalSupplier.isRequired) {
                    Trimmed.LOGGER.error("Could not create paletted image for {}", (Object)this.permutedId);
                }
            }
            finally {
                this.lazyLoadedImage.release();
            }
            return null;
        }

        public void discard() {
            this.lazyLoadedImage.release();
        }
    }

    public record OptionalSupplier(boolean isRequired, java.util.function.Supplier<IntUnaryOperator> mapper) {
    }
}

