/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.dhyces.trimmed.api.codec.SetCodec;
import dev.dhyces.trimmed.api.util.LenientUnboundedMapCodec;
import java.util.function.BiPredicate;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;

public final class CodecUtil {
    public static final Codec<ResourceLocation> TRIMMED_IDENTIFIER = Codec.STRING.xmap(s -> ResourceLocation.tryParse((String)(s.contains(":") ? s : "trimmed:" + s)), ResourceLocation::toString);
    public static final Codec<ModelResourceLocation> MODEL_IDENTIFIER_CODEC = Codec.STRING.comapFlatMap(s -> {
        if (s.contains("#")) {
            String[] identifierModelSplit = s.split("#");
            try {
                ResourceLocation id = ResourceLocation.parse((String)identifierModelSplit[0]);
                return DataResult.success((Object)new ModelResourceLocation(id, identifierModelSplit[1]));
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
        }
        return DataResult.success((Object)new ModelResourceLocation(ResourceLocation.parse((String)s), "inventory"));
    }, modelId -> modelId.getVariant().equals("inventory") ? modelId.id().getNamespace() + ":" + modelId.id().getPath() : modelId.toString());

    public static <K, V> LenientUnboundedMapCodec<K, V> lenientMapCodec(Codec<K> keyCodec, Codec<V> valueCodec, final BiPredicate<DataResult<K>, V> skipFunction) {
        return new LenientUnboundedMapCodec<K, V>(keyCodec, valueCodec){

            @Override
            public boolean shouldSkipKey(DataResult<K> keyParse, V value) {
                return skipFunction.test(keyParse, value);
            }
        };
    }

    public static <T> SetCodec<T> setOf(Codec<T> elementCodec) {
        return new SetCodec<T>(elementCodec);
    }
}

