/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.maps.types;

import com.mojang.serialization.Codec;
import dev.dhyces.trimmed.api.KeyResolver;
import dev.dhyces.trimmed.api.maps.types.MapType;
import dev.dhyces.trimmed.impl.client.maps.KeyResolvers;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class SimpleMapType<K, V>
implements MapType<K, V> {
    private final KeyResolver<K> keyResolver;
    private final Codec<V> valueCodec;
    @Nullable
    private final StreamCodec<RegistryFriendlyByteBuf, V> valueStreamCodec;
    private final boolean dataPackSynced;

    SimpleMapType(KeyResolver<K> keyResolver, Codec<V> valueCodec, @Nullable StreamCodec<RegistryFriendlyByteBuf, V> valueStreamCodec, boolean dataPackSynced) {
        this.keyResolver = keyResolver;
        this.valueCodec = valueCodec;
        this.valueStreamCodec = valueStreamCodec;
        this.dataPackSynced = dataPackSynced;
    }

    public static <K, V> Builder<K, V> builder(KeyResolver<K> keyResolver, Codec<V> valueCodec) {
        return new Builder<K, V>(keyResolver, valueCodec);
    }

    @Override
    public KeyResolver<K> getKeyResolver() {
        return this.keyResolver;
    }

    @Override
    public Codec<V> getValueCodec() {
        return this.valueCodec;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, V> getValueStreamCodec() {
        return this.valueStreamCodec;
    }

    @Override
    public boolean isDataPackSynced() {
        return this.dataPackSynced || this.keyResolver.requiresActiveWorld();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMapType that = (SimpleMapType)o;
        return this.dataPackSynced == that.dataPackSynced && Objects.equals(this.keyResolver, that.keyResolver) && Objects.equals(this.valueCodec, that.valueCodec) && Objects.equals(this.valueStreamCodec, that.valueStreamCodec);
    }

    public int hashCode() {
        return Objects.hash(this.keyResolver, this.valueCodec, this.valueStreamCodec, this.dataPackSynced);
    }

    public String toString() {
        ResourceLocation resolverId = KeyResolvers.getId(this.keyResolver);
        return "SimpleMapType[map_key_resolver: " + String.valueOf(resolverId == null ? "unregistered" : resolverId) + "]";
    }

    public static class Builder<K, V>
    extends MapType.BaseBuilder<K, V> {
        protected Builder(KeyResolver<K> keyResolver, Codec<V> valueCodec) {
            super(keyResolver, valueCodec);
        }

        @Override
        public SimpleMapType<K, V> build() {
            return new SimpleMapType(this.keyResolver, this.valueCodec, this.valueStreamCodec, this.dataPackSynced);
        }
    }
}

