/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.tag;

import dev.dhyces.trimmed.api.KeyResolver;
import dev.dhyces.trimmed.api.client.TrimmedClientApi;
import dev.dhyces.trimmed.api.client.tag.ClientTagKey;
import dev.dhyces.trimmed.api.data.client.tag.ClientTagBuilder;
import dev.dhyces.trimmed.api.data.client.tag.ClientTagEntry;
import dev.dhyces.trimmed.api.data.client.tag.ClientTagFile;
import dev.dhyces.trimmed.api.data.client.tag.appenders.ClientRegistryTagAppender;
import dev.dhyces.trimmed.api.data.tag.NeoBaseClientTagDataProvider;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public abstract class ClientRegistryTagDataProvider<T>
extends NeoBaseClientTagDataProvider<T, KeyResolver.RegistryResolver<T>> {
    private final CompletableFuture<HolderLookup.Provider> lookupProviderFuture;
    private final CompletableFuture<Unit> completed;

    public ClientRegistryTagDataProvider(PackOutput packOutput, String modid, ResourceKey<? extends Registry<T>> registryKey, CompletableFuture<HolderLookup.Provider> lookupProviderFuture, ExistingFileHelper existingFileHelper) {
        super(packOutput, modid, TrimmedClientApi.getInstance().getRegistryKeyResolver(registryKey), existingFileHelper);
        this.lookupProviderFuture = lookupProviderFuture;
        this.completed = new CompletableFuture();
    }

    protected abstract void addTags(HolderLookup.Provider var1);

    public ClientRegistryTagAppender<T> tag(ClientTagKey<T> clientTagKey, HolderLookup.Provider lookupProvider) {
        return new ClientRegistryTagAppender<T>(this.getOrCreateBuilder(clientTagKey), lookupProvider.lookupOrThrow(((KeyResolver.RegistryResolver)this.keyResolver).getKey()));
    }

    public ClientRegistryTagAppender.Mapped<T> tag(ClientTagKey<T> clientTagKey, HolderLookup.Provider lookupProvider, Function<T, @Nullable ResourceLocation> encoder) {
        return new ClientRegistryTagAppender.Mapped<T>(this.getOrCreateBuilder(clientTagKey), lookupProvider.lookupOrThrow(((KeyResolver.RegistryResolver)this.keyResolver).getKey()), encoder);
    }

    protected CompletableFuture<HolderLookup.Provider> createContentProvider() {
        return this.lookupProviderFuture.thenApply(provider -> {
            this.addTags((HolderLookup.Provider)provider);
            return provider;
        });
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        return ((CompletableFuture)this.createContentProvider().thenApply(provider -> {
            this.completed.complete(Unit.INSTANCE);
            return provider;
        })).thenCompose(provider -> {
            Predicate<ResourceLocation> registryCheck = id -> ((HolderLookup.RegistryLookup)provider.lookup(((KeyResolver.RegistryResolver)this.keyResolver).getKey()).orElseThrow(() -> new IllegalStateException("Vanilla registry " + String.valueOf(((KeyResolver.RegistryResolver)this.keyResolver).getKey().location()) + " is not present."))).get(ResourceKey.create(((KeyResolver.RegistryResolver)this.keyResolver).getKey(), (ResourceLocation)id)).isPresent();
            return CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(entry -> {
                ClientTagFile tagFile = ((ClientTagBuilder)entry.getValue()).build();
                List<ClientTagEntry> errors = tagFile.entries().stream().filter(tagEntry -> !tagEntry.verifyExists(registryCheck, this::doesTagExist)).toList();
                if (!errors.isEmpty()) {
                    throw new IllegalStateException("Tag entries [%s] were not found for registry %s".formatted(errors.stream().map(Object::toString).collect(Collectors.joining(",")), ((KeyResolver.RegistryResolver)this.keyResolver).getKey()));
                }
                Path filePath = this.pathProvider.json((ResourceLocation)entry.getKey());
                return DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)provider, ClientTagFile.CODEC, (Object)tagFile, (Path)filePath);
            }).toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "ClientRegistryTagProvider<" + String.valueOf(((KeyResolver.RegistryResolver)this.keyResolver).getKey().location()) + "> for " + this.modid;
    }
}

