/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.map.appenders;

import dev.dhyces.trimmed.api.data.map.MapBuilder;
import dev.dhyces.trimmed.api.data.map.appenders.MapAppender;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RegistryMapAppender<K, V>
extends MapAppender<K, V> {
    private final HolderLookup.RegistryLookup<K> lookup;

    public RegistryMapAppender(MapBuilder<V> builder, HolderLookup.RegistryLookup<K> lookup) {
        super(builder);
        this.lookup = lookup;
    }

    public <S extends RegistryMapAppender<K, V>> S put(ResourceKey<K> key, V value) {
        if (!key.isFor(this.lookup.key())) {
            throw new IllegalArgumentException("Key " + String.valueOf(key.location()) + " is not for registry " + String.valueOf(this.lookup.key()) + "!");
        }
        return (S)((RegistryMapAppender)this.put(key.location(), value));
    }

    public <S extends RegistryMapAppender<K, V>> S putOptional(ResourceKey<K> key, V value) {
        if (!key.isFor(this.lookup.key())) {
            throw new IllegalArgumentException("Key " + String.valueOf(key.location()) + " is not for registry " + String.valueOf(this.lookup.key()) + "!");
        }
        return (S)((RegistryMapAppender)this.putOptional(key.location(), value));
    }

    public RegistryMapAppender<K, V> put(Holder<K> holder, V value) {
        if (!((ResourceKey)holder.unwrapKey().orElseThrow()).isFor(this.lookup.key())) {
            throw new IllegalArgumentException("Element " + String.valueOf(holder) + " is not valid in current registry set");
        }
        return (RegistryMapAppender)this.put(holder.unwrapKey().map(ResourceKey::location).orElseThrow(), value);
    }

    public RegistryMapAppender<K, V> putOptional(Holder<K> holder, V value) {
        if (!((ResourceKey)holder.unwrapKey().orElseThrow()).isFor(this.lookup.key())) {
            throw new IllegalArgumentException("Element " + String.valueOf(holder) + " is not valid in current registry set");
        }
        return (RegistryMapAppender)this.putOptional(holder.unwrapKey().map(ResourceKey::location).orElseThrow(), value);
    }

    public static class Mapped<K, V>
    extends RegistryMapAppender<K, V> {
        protected final Function<K, @Nullable ResourceLocation> encoder;

        public Mapped(MapBuilder<V> builder, HolderLookup.RegistryLookup<K> lookup, Function<K, @Nullable ResourceLocation> encoder) {
            super(builder, lookup);
            this.encoder = encoder;
        }

        public <S extends MapAppender<K, V>> S put(K key, V value) {
            ResourceLocation encoded = this.encoder.apply(key);
            if (encoded == null) {
                throw new IllegalArgumentException("Encoder could not map key to resource location");
            }
            return this.put((K)encoded, value);
        }

        @Override
        public <S extends MapAppender<K, V>> S put(Supplier<K> key, V value) {
            return this.put(key.get(), value);
        }

        public <S extends MapAppender<K, V>> S putOptional(K key, V value) {
            ResourceLocation encoded = this.encoder.apply(key);
            if (encoded == null) {
                throw new IllegalArgumentException("Encoder could not map key to resource location");
            }
            return this.putOptional((K)encoded, value);
        }

        @Override
        public <S extends MapAppender<K, V>> S putOptional(Supplier<K> key, V value) {
            return this.putOptional(key.get(), value);
        }

        public <S extends MapAppender<K, V>> S intrusivePutAll(Map<K, V> map) {
            map.forEach(this::put);
            return this.self();
        }

        public <S extends MapAppender<K, V>> S intrusivePutAllOptional(Map<K, V> map) {
            map.forEach(this::putOptional);
            return this.self();
        }
    }
}

