/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.map.appenders;

import dev.dhyces.trimmed.api.data.map.MapBuilder;
import dev.dhyces.trimmed.api.data.map.appenders.MapAppender;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class MappedMapAppender<K, V>
extends MapAppender<K, V> {
    protected final Function<K, @Nullable ResourceLocation> encoder;

    public MappedMapAppender(MapBuilder<V> builder, Function<K, @Nullable ResourceLocation> encoder) {
        super(builder);
        this.encoder = encoder;
    }

    public <S extends MapAppender<K, V>> S put(K key, V value) {
        ResourceLocation encoded = this.encoder.apply(key);
        if (encoded == null) {
            throw new IllegalArgumentException("Encoder could not map key to resource location");
        }
        return this.put((K)encoded, value);
    }

    public <S extends MapAppender<K, V>> S putOptional(K key, V value) {
        ResourceLocation encoded = this.encoder.apply(key);
        if (encoded == null) {
            throw new IllegalArgumentException("Encoder could not map key to resource location");
        }
        return this.putOptional((K)encoded, value);
    }

    public <S extends MapAppender<K, V>> S intrusivePutAll(Map<K, V> map) {
        map.forEach(this::put);
        return this.self();
    }

    public <S extends MapAppender<K, V>> S intrusivePutAllOptional(Map<K, V> map) {
        map.forEach(this::putOptional);
        return this.self();
    }
}

