/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.map;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.dhyces.trimmed.api.data.map.MapAppendElement;
import dev.dhyces.trimmed.api.data.map.MapFile;
import dev.dhyces.trimmed.api.data.map.MapValue;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public final class MapBuilder<V> {
    private ImmutableMap.Builder<ResourceLocation, MapValue<V>> mapBuilder = ImmutableMap.builder();
    private ImmutableList.Builder<MapAppendElement> appendBuilder = ImmutableList.builder();
    private boolean shouldReplace = false;

    public MapBuilder<V> addEntry(ResourceLocation key, V value) {
        this.mapBuilder.put((Object)key, new MapValue<V>(value, true));
        return this;
    }

    public MapBuilder<V> addOptionalEntry(ResourceLocation key, V value) {
        this.mapBuilder.put((Object)key, new MapValue<V>(value, false));
        return this;
    }

    public MapBuilder<V> addAll(Map<ResourceLocation, MapValue<V>> map) {
        this.mapBuilder.putAll(map);
        return this;
    }

    public MapBuilder<V> append(ResourceLocation mapId) {
        this.appendBuilder.add((Object)new MapAppendElement(mapId, true));
        return this;
    }

    public MapBuilder<V> appendOptional(ResourceLocation mapId) {
        this.appendBuilder.add((Object)new MapAppendElement(mapId, false));
        return this;
    }

    public MapBuilder<V> appendAll(List<MapAppendElement> list) {
        this.appendBuilder.addAll(list);
        return this;
    }

    public MapBuilder<V> merge(MapFile<V> mapFile) {
        if (!mapFile.map().isEmpty()) {
            this.addAll(mapFile.map());
        }
        if (!mapFile.appendElements().isEmpty()) {
            this.appendAll(mapFile.appendElements());
        }
        return this;
    }

    public MapBuilder<V> replaces() {
        this.shouldReplace = true;
        return this;
    }

    public MapFile<V> build() {
        return new MapFile(this.mapBuilder.buildKeepingLast(), (List<MapAppendElement>)this.appendBuilder.build(), this.shouldReplace);
    }
}

