/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.client.tag.appenders;

import dev.dhyces.trimmed.api.KeyResolver;
import dev.dhyces.trimmed.api.client.tag.ClientTagKey;
import dev.dhyces.trimmed.api.data.client.tag.ClientTagBuilder;
import dev.dhyces.trimmed.api.data.client.tag.appenders.ClientTagAppender;
import dev.dhyces.trimmed.api.data.client.tag.appenders.MappedTagExtension;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ClientRegistryTagAppender<T>
extends ClientTagAppender<T> {
    private final HolderLookup.RegistryLookup<T> lookup;

    public ClientRegistryTagAppender(ClientTagBuilder<T> builder, HolderLookup.RegistryLookup<T> lookup) {
        super(builder);
        this.lookup = lookup;
    }

    public ClientRegistryTagAppender<T> add(ResourceKey<T> element) {
        if (!element.isFor(this.lookup.key())) {
            throw new IllegalArgumentException("Element " + String.valueOf(element.location()) + " is not for registry " + String.valueOf(this.lookup.key()) + "!");
        }
        this.add(element.location());
        return this;
    }

    public ClientRegistryTagAppender<T> add(Holder<T> holder) {
        if (!((ResourceKey)holder.unwrapKey().orElseThrow()).isFor(this.lookup.key())) {
            throw new IllegalArgumentException("Element " + String.valueOf(holder) + " is not valid in current registry set");
        }
        return this.add((ResourceKey)holder.unwrapKey().orElseThrow());
    }

    @Override
    public ClientRegistryTagAppender<T> addTag(ClientTagKey<T> tagKey) {
        KeyResolver.RegistryResolver registryResolver;
        KeyResolver<T> keyResolver = tagKey.getKeyResolver();
        if (!(keyResolver instanceof KeyResolver.RegistryResolver) || (registryResolver = (KeyResolver.RegistryResolver)keyResolver).getKey() != this.lookup.key()) {
            throw new IllegalArgumentException("TagKey " + String.valueOf(tagKey) + " is not for registry " + String.valueOf(this.lookup.key()) + "!");
        }
        return this.addTag((ClientTagKey)tagKey);
    }

    public ClientRegistryTagAppender<T> addOptional(ResourceKey<T> element) {
        if (!element.isFor(this.lookup.key())) {
            throw new IllegalArgumentException("Element " + String.valueOf(element.location()) + " is not for registry " + String.valueOf(this.lookup.key()) + "!");
        }
        this.addOptional(element.location());
        return this;
    }

    public ClientRegistryTagAppender<T> addOptional(Holder<T> holder) {
        if (!((ResourceKey)holder.unwrapKey().orElseThrow()).isFor(this.lookup.key())) {
            throw new IllegalArgumentException("Element " + String.valueOf(holder) + " is not valid in current registry set");
        }
        return this.addOptional((ResourceKey)holder.unwrapKey().orElseThrow());
    }

    @Override
    public ClientRegistryTagAppender<T> addOptionalTag(ClientTagKey<T> tagKey) {
        KeyResolver.RegistryResolver registryResolver;
        KeyResolver<T> keyResolver = tagKey.getKeyResolver();
        if (!(keyResolver instanceof KeyResolver.RegistryResolver) || (registryResolver = (KeyResolver.RegistryResolver)keyResolver).getKey() != this.lookup.key()) {
            throw new IllegalArgumentException("TagKey " + String.valueOf(tagKey) + " is not for registry " + String.valueOf(this.lookup.key()) + "!");
        }
        return this.addOptionalTag((ClientTagKey)tagKey);
    }

    public static class Mapped<T>
    extends ClientRegistryTagAppender<T>
    implements MappedTagExtension<T, Mapped<T>> {
        protected final Function<T, @Nullable ResourceLocation> encoder;

        public Mapped(ClientTagBuilder<T> builder, HolderLookup.RegistryLookup<T> lookup, Function<T, @Nullable ResourceLocation> encoder) {
            super(builder, lookup);
            this.encoder = encoder;
        }

        @Override
        public Function<T, @Nullable ResourceLocation> getEncoder() {
            return this.encoder;
        }

        @Override
        public Mapped<T> getSelf() {
            return this;
        }

        @Override
        public ClientRegistryTagAppender<T> add(Supplier<T> element) {
            this.add(element.get());
            return this;
        }

        @Override
        public ClientRegistryTagAppender<T> addOptional(Supplier<T> element) {
            this.addOptional(element.get());
            return this;
        }
    }
}

