/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.client.tag;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.dhyces.trimmed.api.KeyResolver;
import dev.dhyces.trimmed.api.client.tag.ClientTagKey;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public record ClientTagEntry(ExtraCodecs.TagOrElementLocation tagOrElementLocation, boolean isRequired) {
    public static final Codec<ClientTagEntry> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.TAG_OR_ELEMENT_ID.fieldOf("id").forGetter(ClientTagEntry::tagOrElementLocation), (App)Codec.BOOL.fieldOf("required").forGetter(ClientTagEntry::isRequired)).apply((Applicative)instance, ClientTagEntry::new));
    public static final Codec<ClientTagEntry> CODEC = Codec.withAlternative((Codec)ExtraCodecs.TAG_OR_ELEMENT_ID.xmap(either -> new ClientTagEntry((ExtraCodecs.TagOrElementLocation)either, true), ClientTagEntry::tagOrElementLocation), FULL_CODEC);

    public boolean isTag() {
        return this.tagOrElementLocation.tag();
    }

    public ResourceLocation getId() {
        return this.tagOrElementLocation.id();
    }

    public <T> ClientTagKey<T> getTag(KeyResolver<T> keyResolver) {
        return ClientTagKey.of(keyResolver, this.tagOrElementLocation.id());
    }

    public boolean verifyExists(Predicate<ResourceLocation> elementPredicate, Predicate<ResourceLocation> tagPredicate) {
        if (this.tagOrElementLocation.tag()) {
            return tagPredicate.test(this.tagOrElementLocation.id());
        }
        return elementPredicate.test(this.tagOrElementLocation.id());
    }

    public static ClientTagEntry element(ResourceLocation element, boolean isRequired) {
        return new ClientTagEntry(new ExtraCodecs.TagOrElementLocation(element, false), isRequired);
    }

    public static <T> ClientTagEntry clientTagKey(ClientTagKey<T> clientTagKey, boolean isRequired) {
        return new ClientTagEntry(new ExtraCodecs.TagOrElementLocation(clientTagKey.getTagId(), true), isRequired);
    }
}

