/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data;

import dev.dhyces.trimmed.api.client.ClientKeyResolvers;
import dev.dhyces.trimmed.api.client.map.ClientMapKeys;
import dev.dhyces.trimmed.api.client.tag.ClientTags;
import dev.dhyces.trimmed.api.data.BaseTrimDatagenSuite;
import dev.dhyces.trimmed.api.data.map.ClientMapDataProvider;
import dev.dhyces.trimmed.api.data.tag.ClientTagDataProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

public class TrimDatagenSuite
extends BaseTrimDatagenSuite {
    public TrimDatagenSuite(GatherDataEvent event, String modid) {
        this(event, modid, null);
    }

    public TrimDatagenSuite(GatherDataEvent event, final String modid, @Nullable BiConsumer<String, String> translationConsumer) {
        super(modid, translationConsumer);
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        RegistrySetBuilder builder = new RegistrySetBuilder().add(Registries.TRIM_PATTERN, pContext -> this.patterns.forEach((arg_0, arg_1) -> ((BootstrapContext)pContext).register(arg_0, arg_1))).add(Registries.TRIM_MATERIAL, pContext -> this.materials.forEach((arg_0, arg_1) -> ((BootstrapContext)pContext).register(arg_0, arg_1)));
        generator.addProvider(event.includeServer(), pOutput -> new DatapackBuiltinEntriesProvider(this, packOutput, event.getLookupProvider(), builder, Set.of(modid)){

            public String getName() {
                return "TrimDatagenSuite / " + super.getName() + " " + modid;
            }
        });
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(packOutput, event.getLookupProvider()){

            protected void buildRecipes(RecipeOutput output) {
                TrimDatagenSuite.this.trimRecipes.forEach((id, smithingTrimRecipeBuilder) -> smithingTrimRecipeBuilder.save(output, id));
                TrimDatagenSuite.this.copyRecipes.forEach((id, smithingTrimRecipeBuilder) -> smithingTrimRecipeBuilder.save(output));
            }

            public String getName() {
                return "TrimDatagenSuite / " + super.getName() + ": " + modid;
            }
        });
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagsProvider(packOutput, event.getLookupProvider(), CompletableFuture.completedFuture(TagsProvider.TagLookup.empty()), modid, event.getExistingFileHelper()){

            protected void addTags(HolderLookup.Provider pProvider) {
                if (!TrimDatagenSuite.this.patterns.isEmpty()) {
                    this.tag(ItemTags.TRIM_TEMPLATES).add((Object[])((Item[])TrimDatagenSuite.this.patterns.values().stream().map(trimPattern -> (Item)trimPattern.templateItem().value()).toArray(Item[]::new)));
                }
                if (!TrimDatagenSuite.this.materials.isEmpty()) {
                    this.tag(ItemTags.TRIM_MATERIALS).add((Object[])((Item[])TrimDatagenSuite.this.materials.values().stream().map(trimMaterial -> (Item)trimMaterial.ingredient().value()).toArray(Item[]::new)));
                }
            }

            public String getName() {
                return "TrimDatagenSuite / " + super.getName();
            }
        });
        generator.addProvider(event.includeClient(), (DataProvider)new ClientTagDataProvider<ResourceLocation>(packOutput, modid, ClientKeyResolvers.TEXTURE, event.getExistingFileHelper()){

            @Override
            protected void addTags() {
                if (!TrimDatagenSuite.this.patternTextures.isEmpty()) {
                    this.tag(ClientTags.TRIM_PATTERN_TEXTURES).add((ResourceLocation[])TrimDatagenSuite.this.patternTextures.toArray(ResourceLocation[]::new));
                }
            }

            @Override
            public String getName() {
                return "TrimDatagenSuite / " + super.getName();
            }
        });
        generator.addProvider(event.includeClient(), (DataProvider)new ClientMapDataProvider<ResourceLocation>(packOutput, modid, event.getExistingFileHelper()){

            @Override
            protected void addMaps() {
                if (!TrimDatagenSuite.this.materialTexturePermutations.isEmpty()) {
                    this.map(ClientMapKeys.MATERIAL_SUFFIXES).putAll(TrimDatagenSuite.this.materialTexturePermutations);
                }
            }

            @Override
            public String getName() {
                return "TrimDatagenSuite / " + super.getName();
            }
        });
    }

    public static TrimDatagenSuite create(GatherDataEvent event, String modid) {
        return new TrimDatagenSuite(event, modid);
    }

    public static TrimDatagenSuite create(GatherDataEvent event, String modid, @Nullable BiConsumer<String, String> translationConsumer) {
        return new TrimDatagenSuite(event, modid, translationConsumer);
    }
}

