/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.dhyces.trimmed.api.client.override.provider.ItemOverrideProvider;
import dev.dhyces.trimmed.api.client.override.provider.providers.AnyTrimItemOverrideProvider;
import dev.dhyces.trimmed.api.client.override.provider.providers.ComponentItemOverrideProvider;
import dev.dhyces.trimmed.api.data.model.override.ItemOverrideFile;
import dev.dhyces.trimmed.impl.client.models.template.StringTemplate;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public abstract class ItemOverrideDataProvider
implements DataProvider {
    protected final String modid;
    protected final PackOutput dataOutput;
    protected final PackOutput.PathProvider pathResolver;
    private final Map<ItemLike, ItemOverrideFile> providerMap = new Object2ObjectLinkedOpenHashMap();

    public ItemOverrideDataProvider(PackOutput output, String modid) {
        this.dataOutput = output;
        this.pathResolver = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "trimmed/item_model_overrides");
        this.modid = modid;
    }

    protected abstract void addItemOverrides();

    protected void addComponentOverride(ItemLike item, UnaryOperator<DataComponentPatch.Builder> patchBuilder, ResourceLocation itemModelId) {
        this.addItemOverrides(item, new ComponentItemOverrideProvider(((DataComponentPatch.Builder)patchBuilder.apply(DataComponentPatch.builder())).build(), new ModelResourceLocation(itemModelId, "inventory")));
    }

    protected void addComponentOverride(ItemLike item, UnaryOperator<DataComponentPatch.Builder> patchBuilder, ModelResourceLocation modelId) {
        this.addItemOverrides(item, new ComponentItemOverrideProvider(((DataComponentPatch.Builder)patchBuilder.apply(DataComponentPatch.builder())).build(), modelId));
    }

    protected ArmorSetTrimBuilder anyTrimBuilder(ArmorSet armorSet) {
        return new ArmorSetTrimBuilder(armorSet);
    }

    protected void defaultAnyTrim(ArmorSet armorSet) {
        new ArmorSetTrimBuilder(armorSet).defaultTemplate().end();
    }

    protected void addAnyTrimOverride(ItemLike item, StringTemplate stringTemplate) {
        this.addItemOverrides(item, new AnyTrimItemOverrideProvider(stringTemplate));
    }

    protected void addAnyTrimOverride(ItemLike item, String stringTemplate) {
        this.addAnyTrimOverride(item, StringTemplate.of(stringTemplate));
    }

    protected void addAnyTrimOverride(ItemLike item) {
        this.addAnyTrimOverride(item, this.defaultTemplateString(item));
    }

    protected void addItemOverrides(ItemLike item, ItemOverrideProvider ... providers) {
        for (ItemOverrideProvider provider : providers) {
            this.providerMap.computeIfAbsent(item, itemConvertible -> new ItemOverrideFile((Set<ItemOverrideProvider>)new ObjectLinkedOpenHashSet(), false)).overrideProviders().add(provider);
        }
    }

    protected String defaultTemplateString(ItemLike item) {
        return String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).withPrefix("item/")) + "_${material_suffix}_trim";
    }

    public CompletableFuture<?> run(CachedOutput writer) {
        this.addItemOverrides();
        return CompletableFuture.allOf((CompletableFuture[])this.providerMap.entrySet().stream().map(entry -> {
            DataResult encoded = ItemOverrideFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((ItemOverrideFile)entry.getValue()));
            JsonElement json = (JsonElement)encoded.getOrThrow();
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)((ItemLike)entry.getKey()).asItem());
            return DataProvider.saveStable((CachedOutput)writer, (JsonElement)json, (Path)this.pathResolver.json(id));
        }).toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "ItemOverrideProvider for " + this.modid;
    }

    public class ArmorSetTrimBuilder {
        private ArmorSet armorSet;
        private StringTemplate helmetTemplate;
        private StringTemplate chestplateTemplate;
        private StringTemplate leggingsTemplate;
        private StringTemplate bootsTemplate;

        ArmorSetTrimBuilder(ArmorSet armorSet) {
            this.armorSet = armorSet;
        }

        public ArmorSetTrimBuilder defaultTemplate() {
            this.helmetTemplate = StringTemplate.of(ItemOverrideDataProvider.this.defaultTemplateString(this.armorSet.helmet));
            this.chestplateTemplate = StringTemplate.of(ItemOverrideDataProvider.this.defaultTemplateString(this.armorSet.chestplate));
            this.leggingsTemplate = StringTemplate.of(ItemOverrideDataProvider.this.defaultTemplateString(this.armorSet.leggings));
            this.bootsTemplate = StringTemplate.of(ItemOverrideDataProvider.this.defaultTemplateString(this.armorSet.boots));
            return this;
        }

        public ArmorSetTrimBuilder helmetTemplate(String string) {
            this.helmetTemplate = StringTemplate.of(string);
            if (!this.helmetTemplate.getVariables().contains("material_suffix") || this.helmetTemplate.getVariables().size() != 1) {
                throw new IllegalStateException("Only \"material_suffix\" is a valid template variable for \"any_trim\" model overrides");
            }
            return this;
        }

        public ArmorSetTrimBuilder chestplateTemplate(String string) {
            this.chestplateTemplate = StringTemplate.of(string);
            if (!this.chestplateTemplate.getVariables().contains("material_suffix") || this.chestplateTemplate.getVariables().size() != 1) {
                throw new IllegalStateException("Only \"material_suffix\" is a valid template variable for \"any_trim\" model overrides");
            }
            return this;
        }

        public ArmorSetTrimBuilder leggingsTemplate(String string) {
            this.leggingsTemplate = StringTemplate.of(string);
            if (!this.leggingsTemplate.getVariables().contains("material_suffix") || this.leggingsTemplate.getVariables().size() != 1) {
                throw new IllegalStateException("Only \"material_suffix\" is a valid template variable for \"any_trim\" model overrides");
            }
            return this;
        }

        public ArmorSetTrimBuilder bootsTemplate(String string) {
            this.bootsTemplate = StringTemplate.of(string);
            if (!this.bootsTemplate.getVariables().contains("material_suffix") || this.bootsTemplate.getVariables().size() != 1) {
                throw new IllegalStateException("Only \"material_suffix\" is a valid template variable for \"any_trim\" model overrides");
            }
            return this;
        }

        public void end() {
            Objects.requireNonNull(this.helmetTemplate);
            Objects.requireNonNull(this.chestplateTemplate);
            Objects.requireNonNull(this.leggingsTemplate);
            Objects.requireNonNull(this.bootsTemplate);
            ItemOverrideDataProvider.this.addItemOverrides(this.armorSet.helmet, new AnyTrimItemOverrideProvider(this.helmetTemplate));
            ItemOverrideDataProvider.this.addItemOverrides(this.armorSet.chestplate, new AnyTrimItemOverrideProvider(this.chestplateTemplate));
            ItemOverrideDataProvider.this.addItemOverrides(this.armorSet.leggings, new AnyTrimItemOverrideProvider(this.leggingsTemplate));
            ItemOverrideDataProvider.this.addItemOverrides(this.armorSet.boots, new AnyTrimItemOverrideProvider(this.bootsTemplate));
        }
    }

    public record ArmorSet(ItemLike helmet, ItemLike chestplate, ItemLike leggings, ItemLike boots) {
    }
}

