/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class BaseTrimDatagenSuite {
    protected static Pattern replacerPattern = Pattern.compile("(\\b[a-z](?!\\s))");
    @Nullable
    private final BiConsumer<String, String> mainTranslationConsumer;
    protected final String modid;
    protected Map<ResourceKey<TrimPattern>, TrimPattern> patterns = new Reference2ObjectArrayMap();
    protected Map<ResourceLocation, ShapedRecipeBuilder> copyRecipes = new Object2ObjectArrayMap();
    protected Map<ResourceLocation, SmithingTrimRecipeBuilder> trimRecipes = new Object2ObjectArrayMap();
    protected Map<ResourceKey<TrimMaterial>, TrimMaterial> materials = new Reference2ObjectArrayMap();
    protected List<ResourceLocation> patternTextures = new ObjectArrayList();
    protected Map<ResourceLocation, String> materialTexturePermutations = new Object2ObjectArrayMap();

    public BaseTrimDatagenSuite(String modid, @Nullable BiConsumer<String, String> translationConsumer) {
        this.modid = modid;
        this.mainTranslationConsumer = translationConsumer;
        this.generate();
    }

    public void generate() {
    }

    public BaseTrimDatagenSuite makePattern(ResourceKey<TrimPattern> patternKey, Supplier<? extends ItemLike> templateItem) {
        return this.makePattern(patternKey, templateItem.get());
    }

    public BaseTrimDatagenSuite makePattern(ResourceKey<TrimPattern> patternKey, Supplier<? extends ItemLike> templateItem, boolean isDecal, Consumer<PatternConfig> patternConfigConsumer) {
        return this.makePattern(patternKey, templateItem.get(), isDecal, patternConfigConsumer);
    }

    public BaseTrimDatagenSuite makePattern(ResourceKey<TrimPattern> patternKey, ItemLike templateItem) {
        return this.makePattern(patternKey, templateItem, false, (PatternConfig patternConfig) -> {});
    }

    public BaseTrimDatagenSuite makePattern(ResourceKey<TrimPattern> patternKey, ItemLike templateItem, boolean isDecal, Consumer<PatternConfig> patternConfigConsumer) {
        String translationKey = Util.makeDescriptionId((String)"trim_pattern", (ResourceLocation)patternKey.location());
        this.patterns.put(patternKey, new TrimPattern(patternKey.location(), (Holder)templateItem.asItem().builtInRegistryHolder(), (Component)Component.translatable((String)translationKey), isDecal));
        PatternConfig config = new PatternConfig(templateItem);
        patternConfigConsumer.accept(config);
        if (this.mainTranslationConsumer != null) {
            Object translation = config.mainTranslation == null ? replacerPattern.matcher(patternKey.location().getPath().replace("_", " ")).replaceAll(matcher -> matcher.group().toUpperCase()) + " Armor Trim" : config.mainTranslation;
            this.mainTranslationConsumer.accept(translationKey, (String)translation);
        }
        config.altTranslations.forEach(altTranslation -> altTranslation.finish(translationKey));
        if (config.mainTexture == null) {
            this.patternTextures.add(ResourceLocation.fromNamespaceAndPath((String)patternKey.location().getNamespace(), (String)("trims/models/armor/" + patternKey.location().getPath())));
            this.patternTextures.add(ResourceLocation.fromNamespaceAndPath((String)patternKey.location().getNamespace(), (String)("trims/models/armor/" + patternKey.location().getPath() + "_leggings")));
        } else {
            this.patternTextures.add(config.mainTexture);
            this.patternTextures.add(config.leggingsTexture);
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)templateItem.asItem());
        if (!config.omitTrimRecipe) {
            this.trimRecipes.put(id.withSuffix("_smithing_trim"), this.makeTrimRecipe(templateItem));
        }
        if (config.copyRecipe != null) {
            this.copyRecipes.put(id, config.copyRecipe);
        }
        return this;
    }

    protected SmithingTrimRecipeBuilder makeTrimRecipe(ItemLike templateItem) {
        return SmithingTrimRecipeBuilder.smithingTrim((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{templateItem}), (Ingredient)Ingredient.of((TagKey)ItemTags.TRIMMABLE_ARMOR), (Ingredient)Ingredient.of((TagKey)ItemTags.TRIM_MATERIALS), (RecipeCategory)RecipeCategory.MISC).unlocks("has_smithing_trim_template", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{templateItem}));
    }

    public BaseTrimDatagenSuite makeMaterial(ResourceKey<TrimMaterial> materialKey, Supplier<? extends ItemLike> materialItem, int color) {
        return this.makeMaterial(materialKey, materialItem.get(), color);
    }

    public BaseTrimDatagenSuite makeMaterial(ResourceKey<TrimMaterial> materialKey, Supplier<? extends ItemLike> materialItem, int color, Consumer<MaterialConfig> materialConfigConsumer) {
        return this.makeMaterial(materialKey, materialItem.get(), color, materialConfigConsumer);
    }

    public BaseTrimDatagenSuite makeMaterial(ResourceKey<TrimMaterial> materialKey, ItemLike materialItem, int color) {
        return this.makeMaterial(materialKey, materialItem, color, (MaterialConfig materialConfig) -> {});
    }

    public BaseTrimDatagenSuite makeMaterial(ResourceKey<TrimMaterial> materialKey, ItemLike materialItem, int color, Consumer<MaterialConfig> materialConfigConsumer) {
        MaterialConfig config = new MaterialConfig(materialKey, Style.EMPTY.withColor(color));
        materialConfigConsumer.accept(config);
        String translationKey = Util.makeDescriptionId((String)"trim_pattern", (ResourceLocation)materialKey.location());
        this.materials.put(materialKey, new TrimMaterial(config.assetName, (Holder)materialItem.asItem().builtInRegistryHolder(), -1.0f, config.overrides, (Component)Component.translatable((String)translationKey).withStyle(config.materialStyle)));
        if (this.mainTranslationConsumer != null) {
            Object translation = config.mainTranslation == null ? replacerPattern.matcher(materialKey.location().getPath().replace("_", " ")).replaceAll(matcher -> matcher.group().toUpperCase()) + " Material" : config.mainTranslation;
            this.mainTranslationConsumer.accept(translationKey, (String)translation);
        }
        config.altTranslations.forEach(altTranslation -> altTranslation.finish(translationKey));
        if (config.paletteTexture != null) {
            this.materialTexturePermutations.put(config.paletteTexture, config.assetName);
        } else {
            ResourceLocation key = materialKey.location().withPrefix("trims/color_palettes/");
            this.materialTexturePermutations.put(key, config.assetName);
        }
        return this;
    }

    public static class PatternConfig {
        protected final ItemLike templateItem;
        protected String mainTranslation;
        protected Set<AltTranslation> altTranslations = new ObjectOpenHashSet();
        protected ResourceLocation mainTexture;
        protected ResourceLocation leggingsTexture;
        protected ShapedRecipeBuilder copyRecipe;
        protected boolean omitTrimRecipe;

        protected PatternConfig(ItemLike templateItem) {
            this.templateItem = templateItem;
        }

        public PatternConfig langEntry(String translation) {
            this.mainTranslation = translation;
            return this;
        }

        public PatternConfig langEntry(BiConsumer<String, String> translationConsumer, String translation) {
            this.altTranslations.add(new AltTranslation(translationConsumer, translation));
            return this;
        }

        public PatternConfig textureLocations(ResourceLocation main, ResourceLocation leggings) {
            this.mainTexture = main;
            this.leggingsTexture = leggings;
            return this;
        }

        public PatternConfig createCopyRecipe(ItemLike baseItem) {
            this.copyRecipe = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.templateItem, (int)2).define(Character.valueOf('#'), (ItemLike)Items.DIAMOND).define(Character.valueOf('C'), baseItem).define(Character.valueOf('S'), this.templateItem).pattern("#S#").pattern("#C#").pattern("###").unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)this.templateItem.asItem()).getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{this.templateItem}));
            return this;
        }

        public PatternConfig omitTrimRecipe() {
            this.omitTrimRecipe = true;
            return this;
        }
    }

    public static class MaterialConfig {
        protected final ResourceKey<TrimMaterial> materialKey;
        protected final Set<AltTranslation> altTranslations = new ObjectOpenHashSet();
        protected final Map<Holder<ArmorMaterial>, String> overrides = new Reference2ObjectOpenHashMap();
        protected Style materialStyle;
        protected String mainTranslation;
        protected ResourceLocation paletteTexture;
        protected String assetName;

        private MaterialConfig(ResourceKey<TrimMaterial> materialKey, Style materialStyle) {
            this.materialKey = materialKey;
            this.assetName = materialKey.location().toString().replace(":", "_");
            this.materialStyle = materialStyle;
        }

        public MaterialConfig langEntry(String translation) {
            this.mainTranslation = translation;
            return this;
        }

        public MaterialConfig langEntry(BiConsumer<String, String> translationConsumer, String translation) {
            this.altTranslations.add(new AltTranslation(translationConsumer, translation));
            return this;
        }

        public MaterialConfig colorPaletteTexture(ResourceLocation paletteTexture) {
            this.paletteTexture = paletteTexture;
            return this;
        }

        public MaterialConfig style(UnaryOperator<Style> styleOperator) {
            this.materialStyle = (Style)styleOperator.apply(this.materialStyle);
            return this;
        }

        public MaterialConfig assetName(String name) {
            this.assetName = name;
            return this;
        }

        public MaterialConfig armorOverride(Holder<ArmorMaterial> armorMaterial, String assetNameOverride) {
            this.overrides.put(armorMaterial, assetNameOverride);
            return this;
        }

        public MaterialConfig armorOverride(ArmorMaterial armorMaterial, String assetNameOverride) {
            this.armorOverride((Holder<ArmorMaterial>)((Holder)BuiltInRegistries.ARMOR_MATERIAL.getResourceKey((Object)armorMaterial).flatMap(arg_0 -> ((Registry)BuiltInRegistries.ARMOR_MATERIAL).getHolder(arg_0)).orElseThrow()), assetNameOverride);
            return this;
        }

        public MaterialConfig armorOverride(ResourceKey<ArmorMaterial> armorMaterial, String assetNameOverride) {
            this.armorOverride((Holder<ArmorMaterial>)BuiltInRegistries.ARMOR_MATERIAL.getHolderOrThrow(armorMaterial), assetNameOverride);
            return this;
        }
    }

    protected record AltTranslation(BiConsumer<String, String> consumer, String translation) {
        public void finish(String key) {
            this.consumer.accept(key, this.translation);
        }
    }
}

