/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

public class SetCodec<A>
implements Codec<Set<A>> {
    private final Codec<A> elementCodec;

    public SetCodec(Codec<A> codec) {
        this.elementCodec = codec;
    }

    public <T> DataResult<Pair<Set<A>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(consumerConsumer -> {
            ObjectLinkedOpenHashSet linkedSet = new ObjectLinkedOpenHashSet();
            Stream.Builder failed = Stream.builder();
            AtomicReference<DataResult> ref = new AtomicReference<DataResult>(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()));
            consumerConsumer.accept(arg_0 -> this.lambda$decode$2(ops, failed, ref, (Set)linkedSet, arg_0));
            Pair pair = Pair.of(Collections.unmodifiableSet(linkedSet), (Object)ops.createList(failed.build()));
            return ref.getPlain().map(unit -> pair).setPartial((Object)pair);
        });
    }

    public <T> DataResult<T> encode(Set<A> input, DynamicOps<T> ops, T prefix) {
        ListBuilder builder = ops.listBuilder();
        for (A a : input) {
            builder.add(this.elementCodec.encodeStart(ops, a));
        }
        return builder.build(prefix);
    }

    private /* synthetic */ void lambda$decode$2(DynamicOps ops, Stream.Builder failed, AtomicReference ref, Set linkedSet, Object t) {
        DataResult result = this.elementCodec.decode(ops, t);
        result.error().ifPresent(e -> failed.add(t));
        ref.setPlain(((DataResult)ref.getPlain()).apply2stable((unit, o) -> {
            linkedSet.add(o.getFirst());
            return unit;
        }, result));
    }
}

