/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.client.tag;

import dev.dhyces.trimmed.api.client.tag.ClientTagKey;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public interface TagHolder<T> {
    default public ClientTagKey<T> unwrapKeyOrThrow() {
        return this.getKey().orElseThrow(() -> new IllegalStateException("No key is present for map holder"));
    }

    default public Optional<ClientTagKey<T>> getKey() {
        return Optional.ofNullable(this.unwrapKey());
    }

    @Nullable
    public ClientTagKey<T> unwrapKey();

    public Set<T> getSet();

    default public boolean contains(T element) {
        if (!this.isBound()) {
            return false;
        }
        return this.getSet().contains(element);
    }

    public boolean isRequired(T var1);

    public boolean isBound();

    public static <T> TagHolder<T> simpleWrapper(final Set<T> set) {
        return new TagHolder<T>(){

            @Override
            @Nullable
            public ClientTagKey<T> unwrapKey() {
                return null;
            }

            @Override
            public Set<T> getSet() {
                return set;
            }

            @Override
            public boolean contains(T element) {
                return set.contains(element);
            }

            @Override
            public boolean isRequired(T element) {
                return true;
            }

            @Override
            public boolean isBound() {
                return true;
            }
        };
    }
}

