/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.client.tag;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.dhyces.trimmed.api.KeyResolver;
import dev.dhyces.trimmed.impl.client.maps.KeyResolvers;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public final class ClientTagKey<T> {
    private static final Interner<ClientTagKey<?>> INTERNER = Interners.newWeakInterner();
    private final KeyResolver<T> keyResolver;
    private final ResourceLocation id;

    public static <T> Codec<ClientTagKey<T>> codec(KeyResolver<T> keyResolver) {
        return ResourceLocation.CODEC.xmap(resourceLocation -> ClientTagKey.of(keyResolver, resourceLocation), ClientTagKey::getTagId);
    }

    public static <T> Codec<ClientTagKey<T>> tagCodec(KeyResolver<T> keyResolver) {
        return Codec.STRING.comapFlatMap(s -> (s.startsWith("#") ? ResourceLocation.read((String)s.substring(1)) : DataResult.error(() -> "Not a tag id")).map(id -> ClientTagKey.of(keyResolver, id)), clientTagKey -> clientTagKey.getTagId().toString());
    }

    private ClientTagKey(KeyResolver<T> keyResolver, ResourceLocation id) {
        this.keyResolver = keyResolver;
        this.id = id;
    }

    public static <T> ClientTagKey<T> of(KeyResolver<T> keyResolver, ResourceLocation tagId) {
        return (ClientTagKey)INTERNER.intern(new ClientTagKey<T>(keyResolver, tagId));
    }

    public KeyResolver<T> getKeyResolver() {
        return this.keyResolver;
    }

    public ResourceLocation getTagId() {
        return this.id;
    }

    public String toString() {
        return "ClientTagKey[" + String.valueOf(KeyResolvers.getId(this.keyResolver)) + " / " + String.valueOf(this.id) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTagKey that = (ClientTagKey)o;
        return Objects.equals(this.keyResolver, that.keyResolver) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.keyResolver, this.id);
    }
}

