/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.client.override.provider.providers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.dhyces.trimmed.api.client.override.provider.ItemOverrideProviderType;
import dev.dhyces.trimmed.api.client.override.provider.SimpleItemOverrideProvider;
import dev.dhyces.trimmed.api.util.CodecUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class ComponentItemOverrideProvider
extends SimpleItemOverrideProvider {
    public static final MapCodec<ComponentItemOverrideProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DataComponentPatch.CODEC.fieldOf("components").forGetter(componentItemOverrideProvider -> componentItemOverrideProvider.componentPatch), (App)CodecUtil.MODEL_IDENTIFIER_CODEC.fieldOf("model").forGetter(componentItemOverrideProvider -> componentItemOverrideProvider.model)).apply((Applicative)instance, ComponentItemOverrideProvider::new));
    private final DataComponentPatch componentPatch;
    private final ModelResourceLocation model;

    public ComponentItemOverrideProvider(DataComponentPatch componentPatch, ModelResourceLocation modelId) {
        this.componentPatch = componentPatch;
        this.model = modelId;
    }

    @Override
    public SimpleItemOverrideProvider.ModelPair getModelLocation(ItemStack itemStack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
        if (!itemStack.getComponentsPatch().isEmpty()) {
            DataComponentPatch stackPatch = itemStack.getComponentsPatch();
            for (Map.Entry entry : this.componentPatch.entrySet()) {
                Optional testData;
                Optional stackData = stackPatch.get((DataComponentType)entry.getKey());
                if (stackData == null != ((testData = this.componentPatch.get((DataComponentType)entry.getKey())) == null)) {
                    return SimpleItemOverrideProvider.ModelPair.EMPTY;
                }
                if (stackData.isEmpty() != testData.isEmpty()) {
                    return SimpleItemOverrideProvider.ModelPair.EMPTY;
                }
                if (!stackData.isPresent() || !testData.isPresent() || stackData.get().equals(testData.get())) continue;
                return SimpleItemOverrideProvider.ModelPair.EMPTY;
            }
            return new SimpleItemOverrideProvider.ModelPair(null, this.model);
        }
        return SimpleItemOverrideProvider.ModelPair.EMPTY;
    }

    @Override
    public ItemOverrideProviderType<?> getType() {
        return ItemOverrideProviderType.COMPONENT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentItemOverrideProvider that = (ComponentItemOverrideProvider)o;
        return Objects.equals(this.componentPatch, that.componentPatch) && Objects.equals(this.model, that.model);
    }

    public int hashCode() {
        return Objects.hash(this.componentPatch, this.model);
    }
}

