/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.client.override.provider.providers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.dhyces.trimmed.api.client.override.provider.ItemOverrideProviderType;
import dev.dhyces.trimmed.api.client.override.provider.SimpleItemOverrideProvider;
import dev.dhyces.trimmed.impl.client.models.template.StringTemplate;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import org.jetbrains.annotations.Nullable;

public class AnyTrimItemOverrideProvider
extends SimpleItemOverrideProvider {
    public static final MapCodec<AnyTrimItemOverrideProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StringTemplate.CODEC.fieldOf("model_id_template").forGetter(anyTrimItemOverrideProvider -> anyTrimItemOverrideProvider.modelIdTemplate)).apply((Applicative)instance, AnyTrimItemOverrideProvider::new));
    private final StringTemplate modelIdTemplate;

    public AnyTrimItemOverrideProvider(StringTemplate modelIdTemplate) {
        this.modelIdTemplate = modelIdTemplate;
    }

    @Override
    public Optional<BakedModel> getModel(ItemStack itemStack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
        return super.getModel(itemStack, world, entity, seed).filter(model -> model != Minecraft.getInstance().getModelManager().getMissingModel());
    }

    @Override
    public SimpleItemOverrideProvider.ModelPair getModelLocation(ItemStack itemStack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
        Item item = itemStack.getItem();
        if (!(item instanceof ArmorItem)) {
            return SimpleItemOverrideProvider.ModelPair.EMPTY;
        }
        ArmorItem armorItem = (ArmorItem)item;
        Optional materialIdOptional = Optional.ofNullable((ArmorTrim)itemStack.get(DataComponents.TRIM)).map(ArmorTrim::material).flatMap(holder -> holder.unwrapKey().map(key -> key.location().withPath(((TrimMaterial)holder.value()).overrideArmorMaterials().getOrDefault(armorItem.getMaterial(), ((TrimMaterial)holder.value()).assetName()))));
        if (materialIdOptional.isPresent()) {
            ResourceLocation id = ResourceLocation.parse((String)this.modelIdTemplate.process(s -> {
                if (s.equals("material_suffix")) {
                    return ((ResourceLocation)materialIdOptional.get()).getPath();
                }
                return null;
            }));
            return new SimpleItemOverrideProvider.ModelPair(id, new ModelResourceLocation(id.withPath(s -> s.substring(s.indexOf("/") + 1)), "inventory"));
        }
        return SimpleItemOverrideProvider.ModelPair.EMPTY;
    }

    @Override
    public ItemOverrideProviderType<?> getType() {
        return ItemOverrideProviderType.ANY_TRIM;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnyTrimItemOverrideProvider that = (AnyTrimItemOverrideProvider)o;
        return Objects.equals(this.modelIdTemplate, that.modelIdTemplate);
    }

    public int hashCode() {
        return Objects.hashCode(this.modelIdTemplate);
    }
}

