/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.client.map;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import dev.dhyces.trimmed.Trimmed;
import dev.dhyces.trimmed.api.client.ClientKeyResolvers;
import dev.dhyces.trimmed.api.maps.types.MapType;
import dev.dhyces.trimmed.api.util.CodecUtil;
import net.minecraft.resources.ResourceLocation;

public final class ClientMapTypes {
    private static final BiMap<ResourceLocation, MapType<?, ?>> REGISTERED_TYPES = HashBiMap.create();
    public static final Codec<MapType<?, ?>> CODEC = CodecUtil.TRIMMED_IDENTIFIER.xmap(arg_0 -> REGISTERED_TYPES.get(arg_0), arg_0 -> REGISTERED_TYPES.inverse().get(arg_0));
    public static final MapType<ResourceLocation, String> TEXTURE_SUFFIX = ClientMapTypes.registerType(Trimmed.id("texture_suffix"), MapType.simpleBuilder(ClientKeyResolvers.TEXTURE, Codec.STRING).build());
    public static final MapType<ResourceLocation, ResourceLocation> TEXTURE_MAPPING = ClientMapTypes.registerType(Trimmed.id("texture_mapping"), MapType.simpleBuilder(ClientKeyResolvers.TEXTURE, ResourceLocation.CODEC).build());

    private ClientMapTypes() {
    }

    public static void init() {
    }

    public static <K, V> MapType<K, V> registerType(ResourceLocation id, MapType<K, V> mapType) {
        if (REGISTERED_TYPES.putIfAbsent((Object)id, mapType) != null) {
            throw new IllegalArgumentException("Map type with id " + String.valueOf(id) + " already registered");
        }
        return mapType;
    }
}

