/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.tabs.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.item.api.ItemRegistry;
import org.betterx.wover.item.api.ItemStackHelper;
import org.betterx.wover.tabs.api.interfaces.CreativeTabPredicate;
import org.betterx.wover.tabs.api.interfaces.CreativeTabsBuilder;
import org.betterx.wover.tabs.api.interfaces.CreativeTabsBuilderWithItems;
import org.betterx.wover.tabs.api.interfaces.CreativeTabsBuilderWithTab;
import org.betterx.wover.tabs.impl.CreativeTabBuilderImpl;
import org.betterx.wover.tabs.impl.SimpleCreativeTabImpl;

public class CreativeTabManagerImpl
implements CreativeTabsBuilder,
CreativeTabsBuilderWithTab,
CreativeTabsBuilderWithItems {
    public final ModCore C;
    protected final List<SimpleCreativeTabImpl> tabs = new LinkedList<SimpleCreativeTabImpl>();

    public CreativeTabManagerImpl(ModCore modCore) {
        this.C = modCore;
    }

    @Override
    public CreativeTabBuilderImpl createTab(String name) {
        return new CreativeTabBuilderImpl(this, name);
    }

    @Override
    public CreativeTabBuilderImpl createBlockOnlyTab(ItemLike icon) {
        return new CreativeTabBuilderImpl(this, "blocks").setIcon(icon).setPredicate(CreativeTabPredicate.BLOCKS);
    }

    @Override
    public CreativeTabBuilderImpl createItemOnlyTab(ItemLike icon) {
        return new CreativeTabBuilderImpl(this, "items").setIcon(icon).setPredicate(CreativeTabPredicate.ITEMS);
    }

    @Override
    public CreativeTabsBuilderWithItems processRegistries() {
        this.process(ItemRegistry.forMod(this.C).allItems());
        return this;
    }

    @Override
    public CreativeTabsBuilderWithItems process(Stream<Item> items) {
        items.forEach(item -> {
            for (SimpleCreativeTabImpl tab : this.tabs) {
                if (!tab.predicate.contains((Item)item)) continue;
                tab.addItem((Item)item);
                break;
            }
        });
        return this;
    }

    @Override
    public void registerAllTabs() {
        for (SimpleCreativeTabImpl tab : this.tabs) {
            CreativeModeTab tabItem = FabricItemGroup.builder().icon(() -> new ItemStack(tab.icon)).title(tab.title).displayItems((displayParameters, output) -> output.acceptAll(tab.items.stream().map(i -> ItemStackHelper.callItemStackSetupIfPossible(new ItemStack((ItemLike)i), displayParameters.holders())).toList())).build();
            Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, tab.key, (Object)tabItem);
        }
    }
}

