/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.tabs.impl;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.betterx.wover.tabs.api.interfaces.CreativeTabBuilder;
import org.betterx.wover.tabs.api.interfaces.CreativeTabPredicate;
import org.betterx.wover.tabs.api.interfaces.CreativeTabsBuilderWithTab;
import org.betterx.wover.tabs.impl.CreativeTabManagerImpl;
import org.betterx.wover.tabs.impl.SimpleCreativeTabImpl;
import org.jetbrains.annotations.NotNull;

public class CreativeTabBuilderImpl
implements CreativeTabBuilder {
    private final String name;
    private final ResourceLocation id;
    private ItemLike icon;
    private CreativeTabPredicate predicate = item -> true;
    private Component title;
    private final CreativeTabManagerImpl manager;

    CreativeTabBuilderImpl(@NotNull CreativeTabManagerImpl manager, @NotNull String name) {
        this.name = name;
        this.manager = manager;
        this.id = manager.C.mk(name + "_tab");
        this.title = Component.translatable((String)("itemGroup." + manager.C.namespace + "." + name));
    }

    @Override
    public CreativeTabBuilderImpl setIcon(ItemLike icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public CreativeTabBuilderImpl setPredicate(CreativeTabPredicate predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public CreativeTabBuilderImpl setTitle(Component title) {
        this.title = title;
        return this;
    }

    @Override
    public CreativeTabsBuilderWithTab buildAndAdd() {
        if (this.icon == null) {
            throw new IllegalStateException("Icon must be set");
        }
        SimpleCreativeTabImpl res = new SimpleCreativeTabImpl(this.id, this.icon, this.title, this.predicate);
        this.manager.tabs.add(res);
        return this.manager;
    }
}

