/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.item.api.smithing;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.SmithingTemplateItem;
import org.betterx.wover.core.api.ModCore;
import org.spongepowered.include.com.google.common.collect.ImmutableList;

public class SmithingTemplates {
    public static final ChatFormatting TITLE_FORMAT = ChatFormatting.GRAY;
    public static final ChatFormatting DESCRIPTION_FORMAT = ChatFormatting.BLUE;
    public static final ResourceLocation EMPTY_SLOT_HELMET = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_helmet");
    public static final ResourceLocation EMPTY_SLOT_CHESTPLATE = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_chestplate");
    public static final ResourceLocation EMPTY_SLOT_LEGGINGS = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_leggings");
    public static final ResourceLocation EMPTY_SLOT_BOOTS = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_boots");
    public static final ResourceLocation EMPTY_SLOT_HOE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_hoe");
    public static final ResourceLocation EMPTY_SLOT_AXE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_axe");
    public static final ResourceLocation EMPTY_SLOT_SWORD = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_sword");
    public static final ResourceLocation EMPTY_SLOT_SHOVEL = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_shovel");
    public static final ResourceLocation EMPTY_SLOT_PICKAXE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_pickaxe");
    public static final ResourceLocation EMPTY_SLOT_INGOT = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_ingot");
    public static final ResourceLocation EMPTY_SLOT_REDSTONE_DUST = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_redstone_dust");
    public static final ResourceLocation EMPTY_SLOT_DIAMOND = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_diamond");
    public static final List<ResourceLocation> TOOLS = List.of(EMPTY_SLOT_SWORD, EMPTY_SLOT_PICKAXE, EMPTY_SLOT_AXE, EMPTY_SLOT_HOE, EMPTY_SLOT_SHOVEL);
    public static final List<ResourceLocation> ARMOR = List.of(EMPTY_SLOT_HELMET, EMPTY_SLOT_CHESTPLATE, EMPTY_SLOT_LEGGINGS, EMPTY_SLOT_BOOTS);
    public static final List<ResourceLocation> ARMOR_AND_TOOLS = SmithingTemplates.combine(ARMOR, TOOLS);

    public static List<ResourceLocation> combine(List<ResourceLocation> ... sources) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<ResourceLocation> s : sources) {
            builder.addAll(s);
        }
        return builder.build();
    }

    public static Builder create(ModCore modCore, String path) {
        return new Builder(modCore, path);
    }

    public static class Builder {
        private final ModCore C;
        private final String path;
        private List<ResourceLocation> baseSlotEmptyIcons;
        private List<ResourceLocation> additionalSlotEmptyIcons;

        private Builder(ModCore modCore, String path) {
            this.C = modCore;
            this.path = path;
        }

        public Builder setBaseSlotEmptyIcons(List<ResourceLocation> baseSlotEmptyIcons) {
            this.baseSlotEmptyIcons = baseSlotEmptyIcons;
            return this;
        }

        public Builder setAdditionalSlotEmptyIcons(List<ResourceLocation> additionalSlotEmptyIcons) {
            this.additionalSlotEmptyIcons = additionalSlotEmptyIcons;
            return this;
        }

        public SmithingTemplateItem build() {
            if (this.baseSlotEmptyIcons == null || this.baseSlotEmptyIcons.isEmpty()) {
                throw new IllegalStateException("Base slot empty icons must contain at least one icon");
            }
            if (this.additionalSlotEmptyIcons == null || this.additionalSlotEmptyIcons.isEmpty()) {
                throw new IllegalStateException("Additional slot empty icons must contain at least one icon");
            }
            return new SmithingTemplateItem((Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.C.namespace, (String)("smithing_template." + this.path + ".applies_to")))).withStyle(DESCRIPTION_FORMAT), (Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.C.namespace, (String)("smithing_template." + this.path + ".ingredients")))).withStyle(DESCRIPTION_FORMAT), (Component)Component.translatable((String)Util.makeDescriptionId((String)"upgrade", (ResourceLocation)this.C.mk(this.path))).withStyle(TITLE_FORMAT), (Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.C.namespace, (String)("smithing_template." + this.path + ".base_slot_description")))), (Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.C.namespace, (String)("smithing_template." + this.path + ".additions_slot_description")))), this.baseSlotEmptyIcons, this.additionalSlotEmptyIcons, new FeatureFlag[0]);
        }
    }
}

