/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.item.api.armor;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import org.betterx.wover.core.api.registry.BuiltInRegistryManager;

public class CustomArmorMaterial {
    public static Builder start(ResourceLocation location) {
        return new Builder(location);
    }

    public static class Builder {
        private final ResourceLocation location;
        private final EnumMap<ArmorItem.Type, Integer> defense;
        private int enchantmentValue;
        private Holder<SoundEvent> equipSound;
        private float toughness;
        private float knockbackResistance;
        private Supplier<Ingredient> repairIngredientSupplier;
        List<ArmorMaterial.Layer> layers;

        private Builder(ResourceLocation location) {
            this.location = location;
            this.defense = new EnumMap(ArmorItem.Type.class);
        }

        public Builder defense(int boots, int leggings, int chestplate, int helmet, int body) {
            this.defense(ArmorItem.Type.BOOTS, boots);
            this.defense(ArmorItem.Type.LEGGINGS, leggings);
            this.defense(ArmorItem.Type.CHESTPLATE, chestplate);
            this.defense(ArmorItem.Type.HELMET, helmet);
            this.defense(ArmorItem.Type.BODY, body);
            return this;
        }

        public Builder defense(ArmorItem.Type type, int defense) {
            this.defense.put(type, defense);
            return this;
        }

        public Builder enchantmentValue(int enchantmentValue) {
            this.enchantmentValue = enchantmentValue;
            return this;
        }

        public Builder equipSound(Holder<SoundEvent> equipSound) {
            this.equipSound = equipSound;
            return this;
        }

        public Builder toughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        public Builder knockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        public Builder repairIngredientSupplier(Supplier<Ingredient> repairIngredientSupplier) {
            this.repairIngredientSupplier = repairIngredientSupplier;
            return this;
        }

        public Builder layers(List<ArmorMaterial.Layer> layers) {
            this.layers = layers;
            return this;
        }

        protected void validate() throws IllegalStateException {
            if (this.defense.size() != ArmorItem.Type.values().length) {
                throw new IllegalStateException("Defense values must be set for all armor types");
            }
            if (this.enchantmentValue < 0) {
                throw new IllegalStateException("Enchantment value must be non-negative");
            }
            if (this.equipSound == null) {
                throw new IllegalStateException("Equip sound must be set");
            }
            if (this.toughness < 0.0f) {
                throw new IllegalStateException("Toughness must be non-negative");
            }
            if (this.knockbackResistance < 0.0f) {
                throw new IllegalStateException("Knockback resistance must be non-negative");
            }
            if (this.repairIngredientSupplier == null) {
                throw new IllegalStateException("Repair ingredient supplier must be set");
            }
        }

        public ArmorMaterial build() {
            if (this.layers == null) {
                this.layers = List.of(new ArmorMaterial.Layer(this.location));
            }
            this.validate();
            return new ArmorMaterial(this.defense, this.enchantmentValue, this.equipSound, this.repairIngredientSupplier, this.layers, this.toughness, this.knockbackResistance);
        }

        public Holder<ArmorMaterial> buildAndRegister() {
            return BuiltInRegistryManager.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)this.location, (Object)this.build());
        }
    }
}

