/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.enchantment.api;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.betterx.wover.state.api.WorldState;

public class EnchantmentUtils {
    private EnchantmentUtils() {
    }

    public static Holder<Enchantment> getEnchantment(ResourceKey<Enchantment> enchantment) {
        return WorldState.registryAccess().registry(Registries.ENCHANTMENT).flatMap(r -> r.getHolder(enchantment)).orElse(null);
    }

    public static Holder<Enchantment> getEnchantment(Level world, ResourceKey<Enchantment> enchantment) {
        return world.registryAccess().registry(Registries.ENCHANTMENT).flatMap(r -> r.getHolder(enchantment)).orElse(null);
    }

    public static Holder<Enchantment> getEnchantment(HolderLookup.RegistryLookup<Enchantment> lookup, ResourceKey<Enchantment> enchantment) {
        return lookup.get(enchantment).orElse(null);
    }

    public static int getItemEnchantmentLevel(Level world, ResourceKey<Enchantment> enchantment, ItemStack stack) {
        Holder<Enchantment> enc = EnchantmentUtils.getEnchantment(world, enchantment);
        if (enc != null) {
            return EnchantmentHelper.getItemEnchantmentLevel(enc, (ItemStack)stack);
        }
        return 0;
    }

    public static int getItemEnchantmentLevel(Level world, ResourceKey<Enchantment> enchantment, LivingEntity entity) {
        Holder<Enchantment> enc = EnchantmentUtils.getEnchantment(world, enchantment);
        if (enc != null) {
            return EnchantmentHelper.getEnchantmentLevel(enc, (LivingEntity)entity);
        }
        return 0;
    }

    public static boolean enchantInWorld(ItemStack stack, ResourceKey<Enchantment> enchantment, int level, HolderLookup.Provider provider) {
        if (provider == null) {
            return false;
        }
        return EnchantmentUtils.enchantInWorld(stack, enchantment, level, (HolderLookup.RegistryLookup<Enchantment>)((HolderLookup.RegistryLookup)provider.lookup(Registries.ENCHANTMENT).orElse(null)));
    }

    public static boolean enchantInWorld(ItemStack stack, ResourceKey<Enchantment> enchantment, int level, HolderLookup.RegistryLookup<Enchantment> lookup) {
        if (lookup == null) {
            return false;
        }
        return lookup.get(enchantment).map(e -> {
            stack.enchant((Holder)e, level);
            return true;
        }).orElse(false);
    }
}

