/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api.provider;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.jetbrains.annotations.NotNull;

public abstract class WoverLootTableProvider
implements WoverDataProvider<DataProvider> {
    public final String title;
    protected final ModCore modCore;
    protected final LootContextParamSet lootContextType;

    public WoverLootTableProvider(ModCore modCore, LootContextParamSet lootContextType) {
        this(modCore, modCore.namespace, lootContextType);
    }

    public WoverLootTableProvider(ModCore modCore, String title, LootContextParamSet lootContextType) {
        this.modCore = modCore;
        this.title = title;
        this.lootContextType = lootContextType;
    }

    protected abstract void boostrap(@NotNull HolderLookup.Provider var1, @NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> var2);

    public DataProvider getProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        return new LootTableProvider(output, registriesFuture);
    }

    private class LootTableProvider
    implements DataProvider {
        protected final FabricDataOutput output;
        private final CompletableFuture<HolderLookup.Provider> registryLookup;

        public LootTableProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registryLookup) {
            this.output = output;
            this.registryLookup = registryLookup;
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput writer) {
            HashMap builders = new HashMap();
            return this.registryLookup.thenCompose(lookup -> {
                WoverLootTableProvider.this.boostrap((HolderLookup.Provider)lookup, (registryKey, builder) -> {
                    if (builders.containsKey(registryKey.location())) {
                        throw new IllegalStateException("Duplicate loot table for " + String.valueOf(registryKey.location()));
                    }
                    builders.put(registryKey.location(), builder.setParamSet(WoverLootTableProvider.this.lootContextType).build());
                });
                RegistryOps ops = lookup.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
                return CompletableFuture.allOf((CompletableFuture[])builders.entrySet().stream().map(entry -> DataProvider.saveStable((CachedOutput)writer, (JsonElement)((JsonElement)LootTable.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)((LootTable)entry.getValue())).getOrThrow(IllegalStateException::new)), (Path)this.output.createRegistryElementsPathProvider(Registries.LOOT_TABLE).json((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
            });
        }

        @NotNull
        public String getName() {
            return WoverLootTableProvider.this.title;
        }
    }
}

