/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class StructureErode {
    private static final Direction[] DIR = BlocksHelper.makeHorizontal();

    public static void erode(WorldGenLevel world, BoundingBox bounds, int iterations, RandomSource random) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        boolean canDestruct = true;
        for (int i = 0; i < iterations; ++i) {
            for (int x = bounds.minX(); x <= bounds.maxX(); ++x) {
                mut.setX(x);
                block2: for (int z = bounds.minZ(); z <= bounds.maxZ(); ++z) {
                    mut.setZ(z);
                    for (int y = bounds.maxY(); y >= bounds.minY(); --y) {
                        mut.setY(y);
                        BlockState state = world.getBlockState((BlockPos)mut);
                        boolean ignore = StructureErode.ignore(state, world, (BlockPos)mut);
                        if (canDestruct && BlocksHelper.isInvulnerable(state, (BlockGetter)world, (BlockPos)mut) && random.nextInt(8) == 0 && world.isEmptyBlock(mut.below(2))) {
                            int r = MHelper.randRange(1, 4, random);
                            int cx = mut.getX();
                            int cy = mut.getY();
                            int cz = mut.getZ();
                            int x1 = cx - r;
                            int y1 = cy - r;
                            int z1 = cz - r;
                            int x2 = cx + r;
                            int y2 = cy + r;
                            int z2 = cz + r;
                            for (int px = x1; px <= x2; ++px) {
                                int dx = px - cx;
                                dx *= dx;
                                mut.setX(px);
                                for (int py = y1; py <= y2; ++py) {
                                    int dy = py - cy;
                                    dy *= dy;
                                    mut.setY(py);
                                    for (int pz = z1; pz <= z2; ++pz) {
                                        int dz = pz - cz;
                                        dz *= dz;
                                        mut.setZ(pz);
                                        if (dx + dy + dz > r || !BlocksHelper.isInvulnerable(world.getBlockState((BlockPos)mut), (BlockGetter)world, (BlockPos)mut)) continue;
                                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.AIR);
                                    }
                                }
                            }
                            mut.setX(cx);
                            mut.setY(cy);
                            mut.setZ(cz);
                            canDestruct = false;
                            continue;
                        }
                        if (ignore) continue;
                        if (!state.isAir() && random.nextBoolean()) {
                            MHelper.shuffle(DIR, random);
                            block7: for (Direction dir : DIR) {
                                if (!world.isEmptyBlock(mut.relative(dir)) || !world.isEmptyBlock(mut.below().relative(dir))) continue;
                                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.AIR);
                                mut.move(dir).move(Direction.DOWN);
                                int py = mut.getY();
                                while (y >= bounds.minY() - 10) {
                                    mut.setY(py - 1);
                                    if (!world.isEmptyBlock((BlockPos)mut)) {
                                        mut.setY(py);
                                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, state);
                                        continue block7;
                                    }
                                    --y;
                                }
                            }
                            continue block2;
                        }
                        if (random.nextInt(8) != 0 || BlocksHelper.isInvulnerable(world.getBlockState(mut.above()), (BlockGetter)world, (BlockPos)mut)) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.AIR);
                    }
                }
            }
        }
        for (int x = bounds.minX(); x <= bounds.maxX(); ++x) {
            mut.setX(x);
            for (int z = bounds.minZ(); z <= bounds.maxZ(); ++z) {
                mut.setZ(z);
                block11: for (int y = bounds.maxY(); y >= bounds.minY(); --y) {
                    mut.setY(y);
                    BlockState state = world.getBlockState((BlockPos)mut);
                    if (StructureErode.ignore(state, world, (BlockPos)mut) || !world.isEmptyBlock(mut.below())) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.AIR);
                    for (int py = mut.getY(); py >= bounds.minY() - 10; --py) {
                        mut.setY(py - 1);
                        if (world.isEmptyBlock((BlockPos)mut)) continue;
                        mut.setY(py);
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, state);
                        continue block11;
                    }
                }
            }
        }
    }

    public static void erodeIntense(WorldGenLevel world, BoundingBox bounds, RandomSource random) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mut2 = new BlockPos.MutableBlockPos();
        int minY = bounds.minY() - 10;
        for (int x = bounds.minX(); x <= bounds.maxX(); ++x) {
            mut.setX(x);
            for (int z = bounds.minZ(); z <= bounds.maxZ(); ++z) {
                mut.setZ(z);
                for (int y = bounds.maxY(); y >= bounds.minY(); --y) {
                    mut.setY(y);
                    BlockState state = world.getBlockState((BlockPos)mut);
                    if (StructureErode.ignore(state, world, (BlockPos)mut)) continue;
                    if (random.nextInt(6) == 0) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.AIR);
                        if (!random.nextBoolean()) continue;
                        int px = MHelper.floor(random.nextGaussian() * 2.0 + (double)x + 0.5);
                        int pz = MHelper.floor(random.nextGaussian() * 2.0 + (double)z + 0.5);
                        mut2.set(px, y, pz);
                        while (world.getBlockState((BlockPos)mut2).canBeReplaced() && mut2.getY() > minY) {
                            mut2.setY(mut2.getY() - 1);
                        }
                        if (world.getBlockState((BlockPos)mut2).isAir() || !state.canSurvive((LevelReader)world, (BlockPos)mut2)) continue;
                        mut2.setY(mut2.getY() + 1);
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut2, state);
                        continue;
                    }
                    if (random.nextInt(8) != 0) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.AIR);
                }
            }
        }
        StructureErode.drop(world, bounds);
    }

    private static void drop(WorldGenLevel world, BoundingBox bounds) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        HashSet blocks = Sets.newHashSet();
        HashSet edge = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        for (int x = bounds.minX(); x <= bounds.maxX(); ++x) {
            mut.setX(x);
            for (int z = bounds.minZ(); z <= bounds.maxZ(); ++z) {
                mut.setZ(z);
                for (int y = bounds.minY(); y <= bounds.maxY(); ++y) {
                    mut.setY(y);
                    BlockState state = world.getBlockState((BlockPos)mut);
                    if (StructureErode.ignore(state, world, (BlockPos)mut) || !StructureErode.isTerrainNear(world, (BlockPos)mut)) continue;
                    edge.add(mut.immutable());
                }
            }
        }
        if (edge.isEmpty()) {
            return;
        }
        while (!edge.isEmpty()) {
            for (BlockPos center : edge) {
                for (Direction dir : BlocksHelper.DIRECTIONS) {
                    BlockState state = world.getBlockState(center);
                    if (!state.isCollisionShapeFullBlock((BlockGetter)world, center)) continue;
                    mut.set((Vec3i)center).move(dir);
                    if (!bounds.isInside((Vec3i)mut) || StructureErode.ignore(state = world.getBlockState((BlockPos)mut), world, (BlockPos)mut) || blocks.contains(mut)) continue;
                    add.add(mut.immutable());
                }
            }
            blocks.addAll(edge);
            edge.clear();
            edge.addAll(add);
            add.clear();
        }
        int minY = bounds.minY() - 10;
        for (int x = bounds.minX(); x <= bounds.maxX(); ++x) {
            mut.setX(x);
            for (int z = bounds.minZ(); z <= bounds.maxZ(); ++z) {
                mut.setZ(z);
                for (int y = bounds.minY(); y <= bounds.maxY(); ++y) {
                    mut.setY(y);
                    BlockState state = world.getBlockState((BlockPos)mut);
                    if (StructureErode.ignore(state, world, (BlockPos)mut) || blocks.contains(mut)) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.AIR);
                    while (world.getBlockState((BlockPos)mut).canBeReplaced() && mut.getY() > minY) {
                        mut.setY(mut.getY() - 1);
                    }
                    if (mut.getY() <= minY) continue;
                    mut.setY(mut.getY() + 1);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, state);
                }
            }
        }
    }

    private static boolean ignore(BlockState state, WorldGenLevel world, BlockPos pos) {
        if (state.is(CommonBlockTags.END_STONES) || state.is(BlockTags.NYLIUM)) {
            return true;
        }
        return !state.instrument().equals((Object)NoteBlockInstrument.BASEDRUM) || BlocksHelper.isInvulnerable(state, (BlockGetter)world, pos);
    }

    private static boolean isTerrainNear(WorldGenLevel world, BlockPos pos) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (!world.getBlockState(pos.relative(dir)).is(CommonBlockTags.END_STONES)) continue;
            return true;
        }
        return false;
    }

    public static void cover(WorldGenLevel world, BoundingBox bounds, RandomSource random, BlockState defaultBlock) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        for (int x = bounds.minX(); x <= bounds.maxX(); ++x) {
            mut.setX(x);
            for (int z = bounds.minZ(); z <= bounds.maxZ(); ++z) {
                mut.setZ(z);
                BlockState top = SurfaceMaterialProvider.findSurfaceMaterialProvider((Holder<Biome>)world.getBiome((BlockPos)mut)).map(p -> p.getTopMaterial()).orElse(defaultBlock);
                if (top == null) continue;
                for (int y = bounds.maxY(); y >= bounds.minY(); --y) {
                    mut.setY(y);
                    BlockState state = world.getBlockState((BlockPos)mut);
                    if (!state.is(CommonBlockTags.TERRAIN) || world.getBlockState(mut.above()).isSolid()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, top);
                }
            }
        }
    }
}

