/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.LootPoolAccessor;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.bclib.interfaces.tools.AddMineableHammer;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.bclib.interfaces.tools.AddMineablePickaxe;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.bclib.interfaces.tools.AddMineableShovel;
import org.betterx.bclib.interfaces.tools.AddMineableSword;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.wover.tag.api.predefined.CommonItemTags;
import org.betterx.wover.tag.api.predefined.ToolTags;

public class LootUtil {
    public static Optional<List<ItemStack>> getDrops(BlockBehaviour block, BlockState state, LootParams.Builder builder) {
        ResourceKey tableID = block.getLootTable();
        if (tableID == BuiltInLootTables.EMPTY) {
            return Optional.empty();
        }
        LootParams ctx = builder.withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(LootContextParamSets.BLOCK);
        ServerLevel level = ctx.getLevel();
        LootTable table = level.getServer().reloadableRegistries().getLootTable(tableID);
        if (table == LootTable.EMPTY) {
            return Optional.empty();
        }
        return Optional.of(table.getRandomItems(ctx));
    }

    public static boolean addToPool(LootTable.Builder table, int index, ArrayList<LootPoolEntryContainer> newEntries) {
        List<Object> pools = new ArrayList<LootPool>(0);
        try {
            for (Field f : table.getClass().getDeclaredFields()) {
                Object first;
                if (!List.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                List list = (List)f.get(table);
                if (list == null || list.size() <= 0 || (first = list.get(0)) == null || !LootPool.class.isAssignableFrom(first.getClass())) continue;
                pools = list;
                break;
            }
            if (pools != null && pools.size() > index) {
                LootPool pool = (LootPool)pools.get(index);
                LootPoolAccessor acc = (LootPoolAccessor)pool;
                pools.set(index, acc.bcl_mergeEntries(newEntries));
                return true;
            }
        }
        catch (Throwable t) {
            BCLib.LOGGER.error("ERROR building loot table: " + t.getMessage());
        }
        return false;
    }

    public static boolean isCorrectTool(ItemLike block, BlockState state, ItemStack tool) {
        if (tool == null) {
            return false;
        }
        if (state != null && tool.isCorrectToolForDrops(state)) {
            return true;
        }
        if (block instanceof AddMineableAxe && (tool.is(ItemTags.AXES) || tool.is(ToolTags.FABRIC_AXES))) {
            return true;
        }
        if (block instanceof AddMineablePickaxe && (tool.is(ItemTags.PICKAXES) || tool.is(ToolTags.FABRIC_PICKAXES))) {
            return true;
        }
        if (block instanceof AddMineableHoe && (tool.is(ItemTags.HOES) || tool.is(ToolTags.FABRIC_HOES))) {
            return true;
        }
        if (block instanceof AddMineableShovel && (tool.is(ItemTags.SHOVELS) || tool.is(ToolTags.FABRIC_SHOVELS))) {
            return true;
        }
        if (block instanceof AddMineableSword && (tool.is(ItemTags.SWORDS) || tool.is(ToolTags.FABRIC_SWORDS))) {
            return true;
        }
        if (block instanceof AddMineableShears && BaseShearsItem.isShear(tool)) {
            return true;
        }
        return block instanceof AddMineableHammer && tool.is(CommonItemTags.HAMMERS);
    }
}

