/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import java.util.Optional;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import org.betterx.wover.tag.api.predefined.MineableTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LegacyTiers {
    WOOD(0, null, (Tier)Tiers.WOOD),
    STONE(1, (TagKey<Block>)BlockTags.NEEDS_STONE_TOOL, (Tier)Tiers.STONE),
    IRON(2, (TagKey<Block>)BlockTags.NEEDS_IRON_TOOL, (Tier)Tiers.IRON),
    DIAMOND(3, (TagKey<Block>)BlockTags.NEEDS_DIAMOND_TOOL, (Tier)Tiers.DIAMOND),
    GOLD(0, (TagKey<Block>)MineableTags.NEEDS_GOLD_TOOL, (Tier)Tiers.GOLD),
    NETHERITE(4, (TagKey<Block>)MineableTags.NEEDS_NETHERITE_TOOL, (Tier)Tiers.NETHERITE);

    public final int level;
    @Nullable
    public final TagKey<Block> toolRequirementTag;
    @NotNull
    Tier tier;

    private LegacyTiers(@NotNull int level, TagKey<Block> toolRequirementTag, Tier tier) {
        this.level = level;
        this.toolRequirementTag = toolRequirementTag;
        this.tier = tier;
    }

    public static Optional<LegacyTiers> forTier(Tier tier) {
        for (LegacyTiers legacyTier : LegacyTiers.values()) {
            if (legacyTier.tier != tier) continue;
            return Optional.of(legacyTier);
        }
        return Optional.empty();
    }

    public static Optional<LegacyTiers> forLevel(int level) {
        for (LegacyTiers legacyTier : LegacyTiers.values()) {
            if (legacyTier.level != level) continue;
            return Optional.of(legacyTier);
        }
        return Optional.empty();
    }
}

