/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class FullReferenceHolder<T>
implements Holder<T> {
    private final Set<TagKey<T>> tags = Set.of();
    @Nullable
    private final ResourceKey<T> key;
    @Nullable
    private final T value;
    private final ResourceKey<Registry<T>> owner;

    private FullReferenceHolder(ResourceKey<Registry<T>> owner, @Nullable ResourceKey<T> resourceKey, @Nullable T object) {
        this.owner = owner;
        this.key = resourceKey;
        this.value = object;
    }

    public static <T> FullReferenceHolder<T> create(ResourceKey<Registry<T>> owner, ResourceKey<T> resourceKey, @Nullable T object) {
        return new FullReferenceHolder<T>(owner, resourceKey, object);
    }

    public static <T> FullReferenceHolder<T> create(ResourceKey<Registry<T>> owner, ResourceLocation id, @Nullable T object) {
        return new FullReferenceHolder<T>(owner, ResourceKey.create(owner, (ResourceLocation)id), object);
    }

    public ResourceKey<T> key() {
        if (this.key == null) {
            throw new IllegalStateException("Trying to access unbound value '" + String.valueOf(this.value) + "' from registry " + String.valueOf(this.owner));
        }
        return this.key;
    }

    public T value() {
        if (this.value == null) {
            throw new IllegalStateException("Trying to access unbound value '" + String.valueOf(this.key) + "' from registry " + String.valueOf(this.owner));
        }
        return this.value;
    }

    public boolean is(ResourceLocation resourceLocation) {
        return this.key().location().equals((Object)resourceLocation);
    }

    public boolean is(ResourceKey<T> resourceKey) {
        return this.key() == resourceKey;
    }

    public boolean is(TagKey<T> tagKey) {
        return this.tags.contains(tagKey);
    }

    public boolean is(Holder<T> holder) {
        boolean ok;
        boolean bl = ok = this.value != null || this.key != null;
        if (this.value != null) {
            boolean bl2 = ok = ok && this.value.equals(holder.value());
        }
        if (this.key != null) {
            ok = ok && holder.is(this.key);
        }
        return ok;
    }

    public Stream<TagKey<T>> tags() {
        return this.tags.stream();
    }

    public boolean is(Predicate<ResourceKey<T>> predicate) {
        return predicate.test(this.key());
    }

    public boolean canSerializeIn(HolderOwner<T> holderOwner) {
        return true;
    }

    public Either<ResourceKey<T>, T> unwrap() {
        return Either.left(this.key());
    }

    public Optional<ResourceKey<T>> unwrapKey() {
        return Optional.of(this.key());
    }

    public Holder.Kind kind() {
        return Holder.Kind.REFERENCE;
    }

    public boolean isBound() {
        return this.key != null && this.value != null;
    }

    public String toString() {
        return "FullReference{" + String.valueOf(this.key) + "=" + String.valueOf(this.value) + "}";
    }
}

