/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.sdf.operator;

import net.minecraft.util.Mth;
import org.betterx.bclib.noise.OpenSimplexNoise;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.util.MHelper;

public class SDFRadialNoiseMap
extends SDFDisplacement {
    private static final float SIN = Mth.sin((float)0.5f);
    private static final float COS = Mth.cos((float)0.5f);
    private OpenSimplexNoise noise;
    private float intensity = 1.0f;
    private float radius = 1.0f;
    private short offsetX;
    private short offsetZ;

    public SDFRadialNoiseMap() {
        this.setFunction(pos -> {
            float pz;
            if (this.intensity == 0.0f) {
                return Float.valueOf(0.0f);
            }
            float px = pos.x() / this.radius;
            float distance = MHelper.lengthSqr(px, pz = pos.z() / this.radius);
            if (distance > 1.0f) {
                return Float.valueOf(0.0f);
            }
            distance = 1.0f - Mth.sqrt((float)distance);
            float nx = px * COS - pz * SIN;
            float nz = pz * COS + px * SIN;
            return Float.valueOf((distance *= this.getNoise((double)nx * 0.75 + (double)this.offsetX, (double)nz * 0.75 + (double)this.offsetZ)) * this.intensity);
        });
    }

    private float getNoise(double x, double z) {
        return (float)this.noise.eval(x, z) + (float)this.noise.eval(x * 3.0 + 1000.0, z * 3.0) * 0.5f + (float)this.noise.eval(x * 9.0 + 1000.0, z * 9.0) * 0.2f;
    }

    public SDFRadialNoiseMap setSeed(long seed) {
        this.noise = new OpenSimplexNoise(seed);
        return this;
    }

    public SDFRadialNoiseMap setIntensity(float intensity) {
        this.intensity = intensity;
        return this;
    }

    public SDFRadialNoiseMap setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public SDFRadialNoiseMap setOffset(int x, int z) {
        this.offsetX = (short)(x & Short.MAX_VALUE);
        this.offsetZ = (short)(z & Short.MAX_VALUE);
        return this;
    }
}

