/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.registry;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.EntityType;
import org.betterx.bclib.client.render.BaseChestBlockEntityRenderer;
import org.betterx.bclib.furniture.renderer.RenderChair;
import org.betterx.bclib.items.boat.BoatTypeOverride;
import org.betterx.bclib.registry.BaseBlockEntities;

@Environment(value=EnvType.CLIENT)
public class BaseBlockEntityRenders {
    public static void register() {
        BlockEntityRendererRegistry.register(BaseBlockEntities.CHEST, BaseChestBlockEntityRenderer::new);
        LayerDefinition boatModel = BoatModel.createBodyModel();
        LayerDefinition chestBoatModel = ChestBoatModel.createBodyModel();
        LayerDefinition raftModel = RaftModel.createBodyModel();
        LayerDefinition chestRaftModel = ChestRaftModel.createBodyModel();
        BoatTypeOverride.values().forEach(type -> {
            EntityModelLayerRegistry.registerModelLayer((ModelLayerLocation)type.boatModelName, () -> type.isRaft ? raftModel : boatModel);
            EntityModelLayerRegistry.registerModelLayer((ModelLayerLocation)type.chestBoatModelName, () -> type.isRaft ? chestRaftModel : chestBoatModel);
        });
        BaseBlockEntityRenders.registerRender(BaseBlockEntities.CHAIR, RenderChair.class);
    }

    public static void registerRender(EntityType<?> entity, Class<? extends EntityRenderer<?>> renderer) {
        EntityRendererRegistry.register(entity, context -> {
            EntityRenderer render = null;
            try {
                render = (EntityRenderer)renderer.getConstructor(context.getClass()).newInstance(context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return render;
        });
    }
}

