/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.util.BCLDataComponents;
import org.betterx.wover.recipe.api.BaseRecipeBuilder;
import org.betterx.wover.recipe.impl.BaseRecipeBuilderImpl;
import org.jetbrains.annotations.NotNull;

public abstract class BCLBaseRecipeBuilder<I extends BaseRecipeBuilder<I>, R extends Recipe<? extends RecipeInput>>
extends BaseRecipeBuilderImpl<I> {
    protected final Advancement.Builder advancement = Advancement.Builder.advancement();
    protected Ingredient primaryInput;
    protected Ingredient secondaryInput;
    protected RecipeOutputConsumer outputTagConsumer;
    private final boolean dualInput;

    protected BCLBaseRecipeBuilder(@NotNull ResourceLocation id, @NotNull ItemLike output, boolean dualInput) {
        this(id, new ItemStack(output, 1), dualInput);
    }

    protected BCLBaseRecipeBuilder(@NotNull ResourceLocation id, @NotNull ItemStack output, boolean dualInput) {
        super(id, output);
        this.dualInput = dualInput;
        this.group("");
    }

    protected void validate() {
        super.validate();
        if (this.primaryInput == null || this.primaryInput.isEmpty()) {
            this.throwIllegalStateException("Primary input for Recipe can't be 'null', recipe {} will be ignored!");
        }
        if (this.secondaryInput == null && this.dualInput) {
            this.throwIllegalStateException("Secondary input for Recipe can't be 'null', recipe {} will be ignored!");
        }
    }

    public final void build(RecipeOutput ctx) {
        this.validate();
        this.setupAdvancementForResult();
        AdvancementHolder advancementHolder = this.advancement.build(this.createAdvancementId());
        if (this.outputTagConsumer != null) {
            CustomData.update(BCLDataComponents.ANVIL_ENTITY_DATA, (ItemStack)this.output, (Consumer)this.outputTagConsumer);
        }
        R recipe = this.createRecipe(this.id);
        ctx.accept(this.id, recipe, advancementHolder);
    }

    protected abstract R createRecipe(ResourceLocation var1);

    protected void setupAdvancementForResult() {
        this.advancement.parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT).addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)this.id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)this.id)).requirements(AdvancementRequirements.Strategy.OR);
    }

    protected ResourceLocation createAdvancementId() {
        return this.id.withPrefix("recipes/" + this.category.getFolderName() + "/");
    }

    public I setPrimaryInput(ItemLike ... inputs) {
        this.primaryInput = Ingredient.of((ItemLike[])inputs);
        return (I)((Object)this);
    }

    public I setPrimaryInput(TagKey<Item> input) {
        this.primaryInput = Ingredient.of(input);
        return (I)((Object)this);
    }

    public I setPrimaryInputAndUnlock(TagKey<Item> input) {
        this.setPrimaryInput(input);
        this.unlockedBy(input);
        return (I)((Object)this);
    }

    public I setPrimaryInputAndUnlock(ItemLike ... inputs) {
        this.setPrimaryInput(inputs);
        for (ItemLike item : inputs) {
            this.unlockedBy(item);
        }
        return (I)((Object)this);
    }

    public I setSecondaryInput(ItemLike ... inputs) {
        this.secondaryInput = Ingredient.of((ItemLike[])inputs);
        return (I)((Object)this);
    }

    public I setSecondaryInput(TagKey<Item> input) {
        this.secondaryInput = Ingredient.of(input);
        return (I)((Object)this);
    }

    public I setSecondaryInputAndUnlock(TagKey<Item> input) {
        this.setSecondaryInput(input);
        this.unlockedBy(input);
        return (I)((Object)this);
    }

    public I setSecondaryInputAndUnlock(ItemLike ... inputs) {
        this.setSecondaryInput(inputs);
        for (ItemLike item : inputs) {
            this.unlockedBy(item);
        }
        return (I)((Object)this);
    }

    public I setOutputTag(CompoundTag tag) {
        this.outputTagConsumer = itemTag -> {
            for (String k : tag.getAllKeys()) {
                itemTag.put(k, tag.get(k));
            }
        };
        return (I)((Object)this);
    }

    public I setOutputTag(RecipeOutputConsumer consumer) {
        this.outputTagConsumer = consumer;
        return (I)((Object)this);
    }

    public static interface RecipeOutputConsumer
    extends Consumer<CompoundTag> {
    }
}

