/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;

public class AnvilRecipeInput
implements RecipeInput {
    public final int HAMMER_SLOT = 1;
    public final int INGREDIENT_SLOT = 0;
    private final ItemStack hammer;
    private final ItemStack ingredient;

    public AnvilRecipeInput(ItemStack first, ItemStack second, TagKey<Item> allowedTools) {
        if (!first.isEmpty() && (allowedTools == null || first.is(allowedTools))) {
            this.hammer = first;
            this.ingredient = second;
        } else if (!second.isEmpty() && (allowedTools == null || second.is(allowedTools))) {
            this.hammer = second;
            this.ingredient = first;
        } else {
            this.hammer = ItemStack.EMPTY;
            this.ingredient = first;
        }
    }

    public boolean hasHammer() {
        return !this.hammer.isEmpty();
    }

    public boolean hasIngerdient() {
        return !this.ingredient.isEmpty();
    }

    public ItemStack getHammer() {
        return this.hammer;
    }

    public ItemStack getIngredient() {
        return this.ingredient;
    }

    public ItemStack getItem(int i) {
        if (i == 1) {
            return this.hammer;
        }
        if (i == 0) {
            return this.ingredient;
        }
        return ItemStack.EMPTY;
    }

    public int size() {
        if (this.hasHammer() && this.hasIngerdient()) {
            return 2;
        }
        if (this.hasIngerdient() || this.hasHammer()) {
            return 1;
        }
        return 0;
    }
}

