/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.UnknownReceipBookCategory;
import org.betterx.bclib.recipes.AnvilRecipeInput;
import org.betterx.bclib.recipes.BCLBaseRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.betterx.bclib.util.ItemUtil;
import org.betterx.wover.item.api.ItemStackHelper;
import org.betterx.wover.recipe.api.BaseRecipeBuilder;
import org.betterx.wover.recipe.api.BaseUnlockableRecipeBuilder;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.tag.api.TagManager;
import org.betterx.wover.tag.api.predefined.CommonItemTags;
import org.jetbrains.annotations.NotNull;

public class AnvilRecipe
implements Recipe<AnvilRecipeInput>,
UnknownReceipBookCategory {
    public static final String GROUP = "smithing";
    public static final RecipeType<AnvilRecipe> TYPE = BCLRecipeManager.registerType(BCLib.MOD_ID, "smithing");
    public static final Serializer SERIALIZER = BCLRecipeManager.registerSerializer(BCLib.MOD_ID, "smithing", new Serializer());
    public static final ResourceLocation ID = BCLib.makeID("smithing");
    private final Ingredient input;
    private final ItemStack output;
    private final int damage;
    private final TagKey<Item> allowedTools;
    private final int anvilLevel;
    private final int inputCount;

    public static void register() {
    }

    public AnvilRecipe(Ingredient input, ItemStack output, int inputCount, TagKey<Item> allowedTools, int anvilLevel, int damage) {
        this.input = input;
        this.output = ItemStackHelper.callItemStackSetupIfPossible((ItemStack)output);
        this.allowedTools = allowedTools;
        this.anvilLevel = anvilLevel;
        this.inputCount = inputCount;
        this.damage = damage;
    }

    static Builder create(ResourceLocation id, ItemLike output) {
        return new BuilderImpl(id, output);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public boolean matches(AnvilRecipeInput craftingInventory, Level level) {
        return this.matches(craftingInventory);
    }

    public ItemStack assemble(AnvilRecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public static Iterable<Holder<Item>> getAllHammers() {
        Registry registry = WorldState.allStageRegistryAccess().registryOrThrow(CommonItemTags.HAMMERS.registry());
        return registry.getTagOrEmpty(CommonItemTags.HAMMERS);
    }

    public static int getHammerSlot(Container c) {
        ItemStack h = c.getItem(0);
        if (!h.isEmpty() && h.is(CommonItemTags.HAMMERS)) {
            return 0;
        }
        return 1;
    }

    public static int getIngredientSlot(Container c) {
        return Math.abs(AnvilRecipe.getHammerSlot(c) - 1);
    }

    public ItemStack getHammer(AnvilRecipeInput c) {
        return c.hasHammer() ? c.getHammer() : null;
    }

    public ItemStack getIngredient(AnvilRecipeInput c) {
        return c.hasIngerdient() ? c.getIngredient() : null;
    }

    public ItemStack craft(AnvilRecipeInput craftingInventory, Player player) {
        if (!player.isCreative()) {
            if (!this.checkHammerDurability(craftingInventory, player)) {
                return ItemStack.EMPTY;
            }
            ItemStack hammer = this.getHammer(craftingInventory);
            if (hammer != null) {
                hammer.hurtAndBreak(this.damage, (LivingEntity)player, EquipmentSlot.OFFHAND);
                return ItemStack.EMPTY;
            }
        }
        return this.assemble(craftingInventory, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
    }

    public boolean checkHammerDurability(AnvilRecipeInput craftingInventory, Player player) {
        if (player.isCreative()) {
            return true;
        }
        ItemStack hammer = this.getHammer(craftingInventory);
        if (hammer != null) {
            int damage = hammer.getDamageValue() + this.damage;
            return damage < hammer.getMaxDamage();
        }
        return true;
    }

    public boolean matches(AnvilRecipeInput craftingInventory) {
        ItemStack hammer = this.getHammer(craftingInventory);
        if (hammer == null) {
            return false;
        }
        ItemStack material = this.getIngredient(craftingInventory);
        if (material == null) {
            return false;
        }
        int materialCount = material.getCount();
        return this.input.test(this.getIngredient(craftingInventory)) && materialCount >= this.inputCount && hammer.is(this.allowedTools);
    }

    public int getDamage() {
        return this.damage;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public TagKey<Item> getAllowedTools() {
        return this.allowedTools;
    }

    public Ingredient getMainIngredient() {
        return this.input;
    }

    public int getAnvilLevel() {
        return this.anvilLevel;
    }

    public boolean canUse(Item tool) {
        if (tool instanceof TieredItem) {
            TieredItem ti = (TieredItem)tool;
            return ti.builtInRegistryHolder().is(this.allowedTools);
        }
        return false;
    }

    public static boolean isHammer(Item tool) {
        if (tool == null) {
            return false;
        }
        return tool.getDefaultInstance().is(CommonItemTags.HAMMERS);
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)Ingredient.of(BuiltInRegistries.ITEM.stream().filter(AnvilRecipe::isHammer).filter(this::canUse).map(ItemStack::new)));
        defaultedList.add((Object)this.input);
        return defaultedList;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public RecipeType<?> getType() {
        return TYPE;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnvilRecipe that = (AnvilRecipe)o;
        return this.damage == that.damage && (this.allowedTools != null && this.allowedTools.equals(that.allowedTools) || this.allowedTools == null && that.allowedTools == null) && this.input.equals((Object)that.input) && this.output.equals(that.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output, this.damage, this.allowedTools);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AnvilRecipe{");
        sb.append("input=").append(this.input);
        sb.append(", output=").append(this.output);
        sb.append(", damage=").append(this.damage);
        sb.append(", allowedTools=").append(this.allowedTools);
        sb.append(", anvilLevel=").append(this.anvilLevel);
        sb.append(", inputCount=").append(this.inputCount);
        sb.append('}');
        return sb.toString();
    }

    public static class BuilderImpl
    extends BCLBaseRecipeBuilder<Builder, AnvilRecipe>
    implements Builder {
        private TagKey<Item> allowedTools = null;
        private int anvilLevel = 1;
        private int damage = 1;
        private int inputCount = 1;

        protected BuilderImpl(ResourceLocation id, ItemLike output) {
            super(id, output, false);
        }

        @Override
        public Builder setInputCount(int ct) {
            this.inputCount = ct;
            return this;
        }

        @Override
        public Builder setAllowedTools(TagKey<Item> items) {
            this.allowedTools = items;
            return this;
        }

        @Override
        public Builder setAnvilLevel(int level) {
            this.anvilLevel = level;
            return this;
        }

        @Override
        public Builder setDamage(int damage) {
            this.damage = damage;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.inputCount <= 0) {
                this.throwIllegalStateException("Number of input items for Recipe must be positive. Recipe {} will be ignored!");
            }
        }

        @Override
        protected AnvilRecipe createRecipe(ResourceLocation id) {
            return new AnvilRecipe(this.primaryInput, this.output, this.inputCount, this.allowedTools, this.anvilLevel, this.damage);
        }
    }

    public static class Serializer
    implements RecipeSerializer<AnvilRecipe> {
        public static MapCodec<AnvilRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(recipe -> recipe.input), (App)ItemUtil.CODEC_ITEM_STACK_WITH_NBT.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.INT.optionalFieldOf("inputCount", (Object)1).forGetter(recipe -> recipe.inputCount), (App)TagKey.codec((ResourceKey)Registries.ITEM).optionalFieldOf("allowedTools", null).forGetter(recipe -> recipe.allowedTools), (App)Codec.INT.optionalFieldOf("anvilLevel", (Object)1).forGetter(recipe -> recipe.anvilLevel), (App)Codec.INT.optionalFieldOf("damage", (Object)1).forGetter(recipe -> recipe.damage)).apply((Applicative)instance, AnvilRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AnvilRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        public static final StreamCodec<RegistryFriendlyByteBuf, TagKey<Item>> ITEM_TAG_STREAM_CODEC = TagManager.streamCodec((ResourceKey)Registries.ITEM);

        public MapCodec<AnvilRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AnvilRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static AnvilRecipe fromNetwork(RegistryFriendlyByteBuf packetBuffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)packetBuffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)packetBuffer);
            int inputCount = packetBuffer.readVarInt();
            TagKey allowedTools = (TagKey)ITEM_TAG_STREAM_CODEC.decode((Object)packetBuffer);
            int anvilLevel = packetBuffer.readVarInt();
            int damage = packetBuffer.readVarInt();
            return new AnvilRecipe(input, output, inputCount, (TagKey<Item>)allowedTools, anvilLevel, damage);
        }

        public static void toNetwork(RegistryFriendlyByteBuf packetBuffer, AnvilRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)packetBuffer, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)packetBuffer, (Object)recipe.output);
            packetBuffer.writeVarInt(recipe.inputCount);
            ITEM_TAG_STREAM_CODEC.encode((Object)packetBuffer, recipe.allowedTools);
            packetBuffer.writeVarInt(recipe.anvilLevel);
            packetBuffer.writeVarInt(recipe.damage);
        }
    }

    public static interface Builder
    extends BaseRecipeBuilder<Builder>,
    BaseUnlockableRecipeBuilder<Builder> {
        public Builder setInputCount(int var1);

        public Builder setAllowedTools(TagKey<Item> var1);

        public Builder setAnvilLevel(int var1);

        public Builder setDamage(int var1);

        public Builder setPrimaryInput(ItemLike ... var1);

        public Builder setPrimaryInput(TagKey<Item> var1);

        public Builder setPrimaryInputAndUnlock(TagKey<Item> var1);

        public Builder setPrimaryInputAndUnlock(ItemLike ... var1);
    }
}

