/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.AlloyingRecipeWorkstation;
import org.betterx.bclib.interfaces.UnknownReceipBookCategory;
import org.betterx.bclib.recipes.AlloyingRecipeInput;
import org.betterx.bclib.recipes.BCLBaseRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.betterx.bclib.util.ItemUtil;
import org.betterx.wover.item.api.ItemStackHelper;
import org.betterx.wover.recipe.api.BaseRecipeBuilder;
import org.betterx.wover.recipe.api.BaseUnlockableRecipeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlloyingRecipe
implements Recipe<AlloyingRecipeInput>,
UnknownReceipBookCategory {
    public static final String GROUP = "alloying";
    public static final RecipeType<AlloyingRecipe> TYPE = BCLRecipeManager.registerType(BCLib.MOD_ID, "alloying");
    public static final Serializer SERIALIZER = BCLRecipeManager.registerSerializer(BCLib.MOD_ID, "alloying", new Serializer());
    protected final RecipeType<?> type;
    protected final Ingredient primaryInput;
    protected final Ingredient secondaryInput;
    protected final ItemStack output;
    protected final String group;
    protected final float experience;
    protected final int smeltTime;

    private AlloyingRecipe(List<Ingredient> inputs, Optional<String> group, ItemStack output, float experience, int smeltTime) {
        this(group.orElse(""), !inputs.isEmpty() ? inputs.get(0) : null, inputs.size() > 1 ? inputs.get(1) : null, output, experience, smeltTime);
    }

    private AlloyingRecipe(@NotNull String group, Ingredient primaryInput, Ingredient secondaryInput, ItemStack output, float experience, int smeltTime) {
        this.group = group;
        this.primaryInput = primaryInput;
        this.secondaryInput = secondaryInput;
        this.output = ItemStackHelper.callItemStackSetupIfPossible((ItemStack)output);
        this.experience = experience;
        this.smeltTime = smeltTime;
        this.type = TYPE;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getSmeltTime() {
        return this.smeltTime;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)this.primaryInput);
        defaultedList.add((Object)this.secondaryInput);
        return defaultedList;
    }

    public boolean matches(AlloyingRecipeInput inv, Level level) {
        return this.primaryInput.test(inv.getItem(0)) && this.secondaryInput.test(inv.getItem(1)) || this.primaryInput.test(inv.getItem(1)) && this.secondaryInput.test(inv.getItem(0));
    }

    public ItemStack assemble(AlloyingRecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<?> getType() {
        return this.type;
    }

    @Environment(value=EnvType.CLIENT)
    public String getGroup() {
        return this.group;
    }

    @Environment(value=EnvType.CLIENT)
    public ItemStack getToastSymbol() {
        return AlloyingRecipeWorkstation.getWorkstationIcon();
    }

    public static void register() {
    }

    public static class Serializer
    implements RecipeSerializer<AlloyingRecipe> {
        public static final MapCodec<AlloyingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)Ingredient.CODEC_NONEMPTY).fieldOf("ingredients").forGetter(recipe -> List.of(recipe.primaryInput, recipe.secondaryInput)), (App)Codec.STRING.lenientOptionalFieldOf("group").forGetter(recipe -> recipe.group == null || recipe.group.isEmpty() ? Optional.empty() : Optional.ofNullable(recipe.group)), (App)ItemUtil.CODEC_ITEM_STACK_WITH_NBT.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.INT.optionalFieldOf("smelttime", (Object)350).forGetter(recipe -> recipe.smeltTime)).apply((Applicative)instance, AlloyingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlloyingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<AlloyingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlloyingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        public static AlloyingRecipe fromNetwork(RegistryFriendlyByteBuf packetBuffer) {
            String group = packetBuffer.readUtf();
            Ingredient primary = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)packetBuffer);
            Ingredient secondary = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)packetBuffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)packetBuffer);
            float experience = packetBuffer.readFloat();
            int smeltTime = packetBuffer.readVarInt();
            return new AlloyingRecipe(group == null ? "" : group, primary, secondary, output, experience, smeltTime);
        }

        public static void toNetwork(RegistryFriendlyByteBuf packetBuffer, AlloyingRecipe recipe) {
            packetBuffer.writeUtf(recipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)packetBuffer, (Object)recipe.primaryInput);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)packetBuffer, (Object)recipe.secondaryInput);
            ItemStack.STREAM_CODEC.encode((Object)packetBuffer, (Object)recipe.output);
            packetBuffer.writeFloat(recipe.experience);
            packetBuffer.writeVarInt(recipe.smeltTime);
        }
    }

    public static class BuilderImpl
    extends BCLBaseRecipeBuilder<Builder, AlloyingRecipe>
    implements Builder {
        private float experience = 0.0f;
        private int smeltTime = 350;

        private BuilderImpl(ResourceLocation id, ItemLike output) {
            super(id, output, true);
        }

        @Override
        public Builder setOutputTag(CompoundTag tag) {
            return (Builder)super.setOutputTag(tag);
        }

        @Override
        public Builder setInput(ItemLike primaryInput, ItemLike secondaryInput) {
            this.setPrimaryInput(primaryInput);
            this.setSecondaryInput(secondaryInput);
            return this;
        }

        @Override
        public Builder setInput(TagKey<Item> primaryInput, TagKey<Item> secondaryInput) {
            this.setPrimaryInput(primaryInput);
            this.setSecondaryInput(secondaryInput);
            return this;
        }

        @Override
        public Builder setExperience(float amount) {
            this.experience = amount;
            return this;
        }

        @Override
        public Builder setSmeltTime(int time) {
            this.smeltTime = time;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.smeltTime < 0) {
                this.throwIllegalStateException("Smelt-time for recipe {} most be positive!");
            }
        }

        @Override
        protected AlloyingRecipe createRecipe(ResourceLocation id) {
            return new AlloyingRecipe(this.group == null ? "" : this.group, this.primaryInput, this.secondaryInput, this.output, this.experience, this.smeltTime);
        }
    }

    public static interface Builder
    extends BaseRecipeBuilder<Builder>,
    BaseUnlockableRecipeBuilder<Builder> {
        public Builder group(@Nullable String var1);

        public Builder outputCount(int var1);

        public Builder setInput(ItemLike var1, ItemLike var2);

        public Builder setInput(TagKey<Item> var1, TagKey<Item> var2);

        public Builder setExperience(float var1);

        public Builder setSmeltTime(int var1);

        public static Builder create(ResourceLocation id, ItemLike output) {
            return new BuilderImpl(id, output);
        }
    }
}

