/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common.boat;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.items.boat.BoatTypeOverride;
import org.betterx.bclib.items.boat.CustomBoatTypeOverride;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Boat.class})
public abstract class BoatMixin
extends Entity
implements CustomBoatTypeOverride {
    @Unique
    private BoatTypeOverride bcl_type = null;
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> DATA_ID_TYPE;

    public BoatMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void bcl_setCustomType(BoatTypeOverride type) {
        this.bcl_type = type;
        if (type == null) {
            this.entityData.set(DATA_ID_TYPE, (Object)Boat.Type.OAK.ordinal());
        } else {
            this.entityData.set(DATA_ID_TYPE, (Object)this.bcl_type.ordinal());
        }
    }

    @Override
    public BoatTypeOverride bcl_getCustomType() {
        this.bcl_type = BoatTypeOverride.byId((Integer)this.entityData.get(DATA_ID_TYPE));
        return this.bcl_type;
    }

    @Inject(method={"setVariant(Lnet/minecraft/world/entity/vehicle/Boat$Type;)V"}, at={@At(value="HEAD")}, cancellable=true)
    void bcl_setType(Boat.Type type, CallbackInfo ci) {
        if (this.bcl_type != null) {
            this.entityData.set(DATA_ID_TYPE, (Object)this.bcl_type.ordinal());
            ci.cancel();
        }
    }

    @Inject(method={"getVariant()Lnet/minecraft/world/entity/vehicle/Boat$Type;"}, at={@At(value="HEAD")}, cancellable=true)
    void bcl_getBoatType(CallbackInfoReturnable<Boat.Type> cir) {
        BoatTypeOverride type = BoatTypeOverride.byId((Integer)this.entityData.get(DATA_ID_TYPE));
        if (type != null) {
            this.bcl_type = type;
            cir.setReturnValue((Object)Boat.Type.OAK);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    void bcl_addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        BoatTypeOverride type = this.bcl_getCustomType();
        if (type != null) {
            compoundTag.putString("cType", type.name());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    void bcl_readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.contains("cType")) {
            this.bcl_setCustomType(BoatTypeOverride.byName(compoundTag.getString("cType")));
        } else {
            this.bcl_setCustomType(null);
        }
    }

    @Inject(method={"getDropItem"}, at={@At(value="HEAD")}, cancellable=true)
    void bcl_getDropItem(CallbackInfoReturnable<Item> cir) {
        BoatItem boat;
        BoatTypeOverride type = this.bcl_getCustomType();
        if (type != null && (boat = type.getBoatItem()) != null) {
            cir.setReturnValue((Object)boat);
        }
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/Boat;kill()V", shift=At.Shift.AFTER)}, cancellable=true)
    void bcl_checkFallDamage(double d, boolean bl, BlockState blockState, BlockPos blockPos, CallbackInfo ci) {
        BoatTypeOverride type = this.bcl_getCustomType();
        if (type != null && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            int i;
            for (i = 0; i < 3; ++i) {
                this.spawnAtLocation((ItemLike)type.getPlanks());
            }
            for (i = 0; i < 2; ++i) {
                this.spawnAtLocation((ItemLike)Items.STICK);
            }
            this.resetFallDistance();
            ci.cancel();
        }
    }
}

