/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.blocks.BaseAnvilBlock;
import org.betterx.bclib.blocks.LeveledAnvilBlock;
import org.betterx.bclib.interfaces.AnvilScreenHandlerExtended;
import org.betterx.bclib.recipes.AnvilRecipe;
import org.betterx.bclib.recipes.AnvilRecipeInput;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin
extends ItemCombinerMenu
implements AnvilScreenHandlerExtended {
    @Unique
    private List<RecipeHolder<AnvilRecipe>> bcl_recipes = Collections.emptyList();
    @Unique
    private RecipeHolder<AnvilRecipe> bcl_currentRecipe;
    @Unique
    private DataSlot bcl_anvilLevel;

    public AnvilMenuMixin(@Nullable MenuType<?> menuType, int i, Inventory inventory, ContainerLevelAccess containerLevelAccess) {
        super(menuType, i, inventory, containerLevelAccess);
    }

    @Unique
    private AnvilRecipeInput bcl_AnvilRecipeInput(TagKey<Item> allowedTools) {
        return new AnvilRecipeInput(this.inputSlots.getItem(0), this.inputSlots.getItem(1), allowedTools);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="TAIL")})
    public void be_initAnvilLevel(int syncId, Inventory inventory, ContainerLevelAccess context, CallbackInfo info) {
        this.bcl_anvilLevel = this.addDataSlot(DataSlot.standalone());
        if (context != ContainerLevelAccess.NULL) {
            int level = (Integer)context.evaluate((world, blockPos) -> {
                Block anvilBlock = world.getBlockState(blockPos).getBlock();
                return LeveledAnvilBlock.getAnvilCraftingLevel(anvilBlock);
            }, (Object)0);
            this.bcl_anvilLevel.set(level);
        } else {
            this.bcl_anvilLevel.set(0);
        }
    }

    @Shadow
    public abstract void createResult();

    @Inject(method={"mayPickup"}, at={@At(value="HEAD")}, cancellable=true)
    protected void bcl_canTakeOutput(Player player, boolean present, CallbackInfoReturnable<Boolean> info) {
        if (this.bcl_currentRecipe != null) {
            AnvilRecipeInput recipeInput = this.bcl_AnvilRecipeInput(((AnvilRecipe)this.bcl_currentRecipe.value()).getAllowedTools());
            info.setReturnValue((Object)((AnvilRecipe)this.bcl_currentRecipe.value()).checkHammerDurability(recipeInput, player));
        }
    }

    @Inject(method={"lambda$onTake$2(Lnet/minecraft/world/entity/player/Player;FLnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void bcl_onDamageAnvil(Player player, float adapter_injected_1, Level level, BlockPos blockPos, CallbackInfo ci) {
        Block block;
        BlockState blockState = level.getBlockState(blockPos);
        if (!player.getAbilities().instabuild && (block = blockState.getBlock()) instanceof BaseAnvilBlock) {
            BaseAnvilBlock anvil = (BaseAnvilBlock)block;
            if (player.getRandom().nextDouble() < 0.12) {
                BlockState damaged = anvil.damageAnvilUse(blockState, player.getRandom());
                BaseAnvilBlock.destroyWhenNull(level, blockPos, damaged);
                ci.cancel();
            }
        }
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")}, cancellable=true)
    protected void bcl_onTakeAnvilOutput(Player player, ItemStack stack, CallbackInfo info) {
        if (this.bcl_currentRecipe != null) {
            AnvilRecipeInput recipeInput = this.bcl_AnvilRecipeInput(((AnvilRecipe)this.bcl_currentRecipe.value()).getAllowedTools());
            recipeInput.getIngredient().shrink(((AnvilRecipe)this.bcl_currentRecipe.value()).getInputCount());
            stack = ((AnvilRecipe)this.bcl_currentRecipe.value()).craft(recipeInput, player);
            this.slotsChanged(this.inputSlots);
            this.access.execute((level, blockPos) -> {
                BlockState anvilState = level.getBlockState(blockPos);
                Block anvilBlock = anvilState.getBlock();
                if (anvilBlock instanceof BaseAnvilBlock) {
                    BaseAnvilBlock anvil = (BaseAnvilBlock)anvilBlock;
                    if (!player.getAbilities().instabuild && anvilState.is(BlockTags.ANVIL) && player.getRandom().nextDouble() < 0.1) {
                        BlockState damagedState = anvil.damageAnvilUse(anvilState, player.getRandom());
                        BaseAnvilBlock.destroyWhenNull(level, blockPos, damagedState);
                    } else {
                        level.levelEvent(1030, blockPos, 0);
                    }
                }
            });
            info.cancel();
        }
    }

    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    public void bcl_updateOutput(CallbackInfo info) {
        AnvilRecipeInput recipeInput = this.bcl_AnvilRecipeInput(null);
        RecipeManager recipeManager = this.player.level().getRecipeManager();
        this.bcl_recipes = recipeManager.getRecipesFor(AnvilRecipe.TYPE, (RecipeInput)recipeInput, this.player.level());
        if (!this.bcl_recipes.isEmpty()) {
            int anvilLevel = this.bcl_anvilLevel.get();
            this.bcl_recipes = this.bcl_recipes.stream().filter(recipe -> anvilLevel >= ((AnvilRecipe)recipe.value()).getAnvilLevel()).collect(Collectors.toList());
            if (!this.bcl_recipes.isEmpty()) {
                if (this.bcl_currentRecipe == null || !this.bcl_recipes.contains(this.bcl_currentRecipe)) {
                    this.bcl_currentRecipe = this.bcl_recipes.get(0);
                }
                this.bcl_updateResult();
                info.cancel();
            } else {
                this.bcl_currentRecipe = null;
            }
        }
    }

    @Inject(method={"setItemName"}, at={@At(value="HEAD")}, cancellable=true)
    public void bcl_setNewItemName(String string, CallbackInfoReturnable<Boolean> cir) {
        if (this.bcl_currentRecipe != null) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == 0) {
            this.be_previousRecipe();
            return true;
        }
        if (id == 1) {
            this.be_nextRecipe();
            return true;
        }
        return super.clickMenuButton(player, id);
    }

    @Unique
    private void bcl_updateResult() {
        if (this.bcl_currentRecipe == null) {
            return;
        }
        AnvilRecipeInput recipeInput = this.bcl_AnvilRecipeInput(((AnvilRecipe)this.bcl_currentRecipe.value()).getAllowedTools());
        this.resultSlots.setItem(0, ((AnvilRecipe)this.bcl_currentRecipe.value()).assemble(recipeInput, (HolderLookup.Provider)this.player.level().registryAccess()));
        this.broadcastChanges();
    }

    @Override
    public void bcl_updateCurrentRecipe(RecipeHolder<AnvilRecipe> recipe) {
        this.bcl_currentRecipe = recipe;
        this.bcl_updateResult();
    }

    @Override
    public RecipeHolder<AnvilRecipe> bcl_getCurrentRecipe() {
        return this.bcl_currentRecipe;
    }

    @Override
    public List<RecipeHolder<AnvilRecipe>> bcl_getRecipes() {
        return this.bcl_recipes;
    }
}

