/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.AirSelectionItem;
import org.betterx.bclib.mixin.client.LevelRendererAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugRenderer.class})
@Environment(value=EnvType.CLIENT)
public class DebugRendererMixin {
    @Inject(method={"render"}, at={@At(value="TAIL")})
    void bcl_render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double camX, double camY, double camZ, CallbackInfo ci) {
        HitResult hitResult;
        Minecraft minecraft = Minecraft.getInstance();
        if (BCLib.isDevEnvironment() && (hitResult = minecraft.hitResult) instanceof BlockHitResult) {
            AirSelectionItem airSelect;
            Item item;
            ItemStack item2;
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (minecraft.player != null && (item2 = minecraft.player.getMainHandItem()) != null && (item = item2.getItem()) instanceof AirSelectionItem && (airSelect = (AirSelectionItem)item).renderAirSelection() && blockHitResult.getType() == HitResult.Type.MISS) {
                BlockPos pos = blockHitResult.getBlockPos();
                BlockState state = Blocks.DIRT.defaultBlockState();
                int color = airSelect.airSelectionColor();
                VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
                Camera camera = minecraft.gameRenderer.getMainCamera();
                Vec3 camPos = camera.getPosition();
                LevelRendererAccessor.bclib_renderShape(poseStack, consumer, state.getShape((BlockGetter)minecraft.level, pos, CollisionContext.of((Entity)camera.getEntity())), (double)pos.getX() - camPos.x(), (double)pos.getY() - camPos.y(), (double)pos.getZ() - camPos.z(), (float)FastColor.ARGB32.red((int)color) / 255.0f, (float)FastColor.ARGB32.green((int)color) / 255.0f, (float)FastColor.ARGB32.blue((int)color) / 255.0f, (float)FastColor.ARGB32.alpha((int)color) / 255.0f);
            }
        }
    }
}

