/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items.boat;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.items.boat.BaseBoatItem;
import org.betterx.wover.core.api.ModCore;

public final class BoatTypeOverride {
    private static final String DEFAULT_LAYER = "main";
    private static final List<BoatTypeOverride> values = new ArrayList<BoatTypeOverride>(8);
    private final String name;
    private final Block planks;
    private final int ordinal;
    public final ResourceLocation id;
    public final ResourceLocation boatTexture;
    public final ResourceLocation chestBoatTexture;
    public final ModelLayerLocation boatModelName;
    public final ModelLayerLocation chestBoatModelName;
    @Environment(value=EnvType.CLIENT)
    private ListModel<Boat> boatModel;
    @Environment(value=EnvType.CLIENT)
    private ListModel<Boat> chestBoatModel;
    private BoatItem boat;
    private BoatItem chestBoat;
    public final boolean isRaft;

    BoatTypeOverride(ModCore modCore, String name, Block planks) {
        this(modCore, name, planks, false);
    }

    BoatTypeOverride(ModCore modCore, String name, Block planks, boolean isRaft) {
        this.id = modCore.mk(name);
        this.name = name;
        this.planks = planks;
        int nr = Objects.hash(name);
        if (nr >= 0 && nr <= 1000) {
            nr += 1000;
        }
        while (BoatTypeOverride.byId(nr) != null) {
            BCLib.LOGGER.warn("Boat Type Ordinal " + nr + " is already used, searching for another one");
            if (++nr < 0 || nr > 1000) continue;
            nr += 1000;
        }
        this.ordinal = nr;
        this.isRaft = isRaft;
        if (BCLib.isClient()) {
            this.boatModelName = BoatTypeOverride.createBoatModelName(this.id.getNamespace(), this.id.getPath());
            this.chestBoatModelName = BoatTypeOverride.createChestBoatModelName(this.id.getNamespace(), this.id.getPath());
            this.boatTexture = BoatTypeOverride.getTextureLocation(modCore.namespace, name, false);
            this.chestBoatTexture = BoatTypeOverride.getTextureLocation(modCore.namespace, name, true);
        } else {
            this.boatModelName = null;
            this.chestBoatModelName = null;
            this.boatTexture = null;
            this.chestBoatTexture = null;
        }
        values.add(this);
    }

    @Environment(value=EnvType.CLIENT)
    public ListModel<Boat> getBoatModel(boolean chest) {
        return chest ? this.chestBoatModel : this.boatModel;
    }

    @Environment(value=EnvType.CLIENT)
    public void createBoatModels(EntityRendererProvider.Context context) {
        if (BCLib.isClient() && this.boatModel == null) {
            if (this.isRaft) {
                this.boatModel = new RaftModel(context.bakeLayer(this.boatModelName));
                this.chestBoatModel = new ChestRaftModel(context.bakeLayer(this.chestBoatModelName));
            } else {
                this.boatModel = new BoatModel(context.bakeLayer(this.boatModelName));
                this.chestBoatModel = new ChestBoatModel(context.bakeLayer(this.chestBoatModelName));
            }
        }
    }

    public Block getPlanks() {
        return this.planks;
    }

    public void setBoatItem(BoatItem item) {
        this.boat = item;
    }

    public BoatItem getBoatItem() {
        return this.boat;
    }

    public void setChestBoatItem(BoatItem item) {
        this.chestBoat = item;
    }

    public BoatItem getChestBoatItem() {
        return this.chestBoat;
    }

    public static Stream<BoatTypeOverride> values() {
        return values.stream();
    }

    private static ModelLayerLocation createBoatModelName(String modID, String name) {
        return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)modID, (String)("boat/" + name)), DEFAULT_LAYER);
    }

    private static ModelLayerLocation createChestBoatModelName(String modID, String name) {
        return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)modID, (String)("chest_boat/" + name)), DEFAULT_LAYER);
    }

    private static ResourceLocation getTextureLocation(String modID, String name, boolean chest) {
        if (chest) {
            return ResourceLocation.fromNamespaceAndPath((String)modID, (String)("textures/entity/chest_boat/" + name + ".png"));
        }
        return ResourceLocation.fromNamespaceAndPath((String)modID, (String)("textures/entity/boat/" + name + ".png"));
    }

    public static BoatTypeOverride create(ModCore modCore, String name, Block planks) {
        return BoatTypeOverride.create(modCore, name, planks, false);
    }

    public static BoatTypeOverride create(ModCore modCore, String name, Block planks, boolean isRaft) {
        BoatTypeOverride t = new BoatTypeOverride(modCore, name, planks, isRaft);
        return t;
    }

    public BoatItem createItem(boolean hasChest) {
        return this.createItem(hasChest, new Item.Properties().stacksTo(1));
    }

    public BoatItem createItem(boolean hasChest, Item.Properties itemSettings) {
        BaseBoatItem item = new BaseBoatItem(hasChest, this, itemSettings);
        if (hasChest) {
            this.setChestBoatItem(item);
        } else {
            this.setBoatItem(item);
        }
        return item;
    }

    public static BoatTypeOverride byId(int i) {
        for (BoatTypeOverride t : values) {
            if (t.ordinal != i) continue;
            return t;
        }
        return null;
    }

    public static BoatTypeOverride byName(String string) {
        for (BoatTypeOverride t : values) {
            if (!t.name().equals(string)) continue;
            return t;
        }
        return null;
    }

    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BoatTypeOverride that = (BoatTypeOverride)obj;
        return Objects.equals(this.name, that.name) && this.ordinal == that.ordinal;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ordinal);
    }

    public String toString() {
        return "BoatTypeOverride[name=" + this.name + ", ordinal=" + this.ordinal + "]";
    }
}

