/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.betterx.bclib.items.ModelProviderItem;

public class BaseDrinkItem
extends ModelProviderItem {
    public BaseDrinkItem(Item.Properties settings) {
        super(settings);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)user, (InteractionHand)hand);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        FoodProperties foodProperties = (FoodProperties)stack.get(DataComponents.FOOD);
        if (foodProperties != null) {
            int count = stack.getCount();
            user.eat(level, stack);
            stack.setCount(count);
        }
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)user;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayerEntity, stack);
            serverPlayerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (user instanceof Player && !((Player)user).getAbilities().instabuild) {
            stack.shrink(1);
        }
        if (!level.isClientSide) {
            user.removeAllEffects();
        }
        return stack.isEmpty() ? new ItemStack((ItemLike)Items.GLASS_BOTTLE) : stack;
    }
}

